/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.dnssec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Flags;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.RRSIGRecord;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.dnssec.SRRset;
import org.xbill.DNS.dnssec.SecurityStatus;

final class SMessage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SMessage.class);
    private static final int NUM_SECTIONS = 3;
    private static final int MAX_FLAGS = 16;
    private static final int EXTENDED_FLAGS_BIT_OFFSET = 4;
    private final Header header;
    private Record question;
    private OPTRecord oPTRecord;
    private final List<SRRset>[] sections = new List[3];
    private SecurityStatus securityStatus;
    private String bogusReason;
    private int edeReason = -1;

    public SMessage(Header h2) {
        this.header = h2;
        this.securityStatus = SecurityStatus.UNCHECKED;
    }

    public SMessage(int id, Record question) {
        this(new Header(id));
        this.question = question;
    }

    public SMessage(Message m4) {
        this(m4.getHeader());
        this.question = m4.getQuestion();
        this.oPTRecord = m4.getOPT();
        for (int i = 1; i <= 3; ++i) {
            for (RRset rrset : m4.getSectionRRsets(i)) {
                this.addRRset(new SRRset(rrset), i);
            }
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public Record getQuestion() {
        return this.question;
    }

    public List<SRRset> getSectionRRsets(int section) {
        this.checkSectionValidity(section);
        if (this.sections[section - 1] == null) {
            this.sections[section - 1] = new LinkedList<SRRset>();
        }
        return this.sections[section - 1];
    }

    private void addRRset(SRRset srrset, int section) {
        this.checkSectionValidity(section);
        if (srrset.getType() == 41) {
            this.oPTRecord = (OPTRecord)srrset.first();
            return;
        }
        List<SRRset> sectionList = this.getSectionRRsets(section);
        sectionList.add(srrset);
    }

    private void checkSectionValidity(int section) {
        if (section <= 0 || section > 3) {
            throw new IllegalArgumentException("Invalid section");
        }
    }

    public List<SRRset> getSectionRRsets(int section, int qtype) {
        List<SRRset> slist = this.getSectionRRsets(section);
        if (slist.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SRRset> result = new ArrayList<SRRset>(slist.size());
        for (SRRset rrset : slist) {
            if (rrset.getType() != qtype) continue;
            result.add(rrset);
        }
        return result;
    }

    public int getRcode() {
        int rcode = this.header.getRcode();
        if (this.oPTRecord != null) {
            rcode += this.oPTRecord.getExtendedRcode() << 4;
        }
        return rcode;
    }

    public SecurityStatus getStatus() {
        return this.securityStatus;
    }

    public void setStatus(SecurityStatus status, int edeReason) {
        this.setStatus(status, edeReason, null);
    }

    public void setStatus(SecurityStatus status, int edeReason, String reason) {
        this.securityStatus = status;
        this.edeReason = edeReason;
        this.bogusReason = reason;
        if (reason != null) {
            log.debug("Setting bad reason for message to {}", (Object)reason);
        }
    }

    public void setBogus(String reason) {
        this.setStatus(SecurityStatus.BOGUS, 6, reason);
    }

    public void setBogus(String reason, int edeReason) {
        this.setStatus(SecurityStatus.BOGUS, edeReason, reason);
    }

    public String getBogusReason() {
        return this.bogusReason;
    }

    public int getEdeReason() {
        return this.edeReason;
    }

    public Message getMessage() {
        Message m4 = new Message(this.header.getID());
        Header h2 = m4.getHeader();
        h2.setOpcode(this.header.getOpcode());
        h2.setRcode(this.header.getRcode());
        for (int i = 0; i < 16; ++i) {
            if (!Flags.isFlag(i) || !this.header.getFlag(i)) continue;
            h2.setFlag(i);
        }
        if (this.question != null) {
            m4.addRecord(this.question, 0);
        }
        for (int sec = 1; sec <= 3; ++sec) {
            List<SRRset> slist = this.getSectionRRsets(sec);
            for (SRRset rrset : slist) {
                for (Record record : rrset.rrs()) {
                    m4.addRecord(record, sec);
                }
                for (RRSIGRecord rRSIGRecord : rrset.sigs()) {
                    m4.addRecord(rRSIGRecord, sec);
                }
            }
        }
        if (this.oPTRecord != null) {
            m4.addRecord(this.oPTRecord, 3);
        }
        return m4;
    }

    public int getCount(int section) {
        if (section == 0) {
            return 1;
        }
        List<SRRset> sectionList = this.getSectionRRsets(section);
        if (sectionList.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (SRRset sr : sectionList) {
            count += sr.size();
        }
        return count;
    }

    public SRRset findRRset(Name name, int type, int dclass, int section) {
        this.checkSectionValidity(section);
        for (SRRset set : this.getSectionRRsets(section)) {
            if (!set.getName().equals(name) || set.getType() != type || set.getDClass() != dclass) continue;
            return set;
        }
        return null;
    }

    public SRRset findAnswerRRset(Name qname, int qtype, int qclass) {
        return this.findRRset(qname, qtype, qclass, 1);
    }
}

