/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.locator;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.api.NotFoundException;
import network.oxalis.vefa.peppol.lookup.locator.AbstractLocator;
import network.oxalis.vefa.peppol.lookup.locator.CustomExtendedDNSResolver;
import network.oxalis.vefa.peppol.lookup.util.DynamicHostnameGenerator;
import network.oxalis.vefa.peppol.mode.Mode;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.TextParseException;

public class BusdoxLocator
extends AbstractLocator {
    private long timeout = 30L;
    private int maxRetries = 3;
    private static final List<InetAddress> customDNSServers = new ArrayList<InetAddress>();
    public static InetAddress GOOGLE_PRIMARY_DNS;
    public static InetAddress GOOGLE_SECONDARY_DNS;
    public static InetAddress CLOUDFLARE_PRIMARY_DNS;
    public static InetAddress CLOUDFLARE_SECONDARY_DNS;
    private final DynamicHostnameGenerator hostnameGenerator;

    public BusdoxLocator(Mode mode) {
        this(mode.getString("lookup.locator.busdox.prefix"), mode.getString("lookup.locator.hostname"), mode.getString("lookup.locator.busdox.algorithm"));
        this.maxRetries = Integer.parseInt(mode.getString("lookup.locator.busdox.maxRetries"));
        this.timeout = Long.parseLong(mode.getString("lookup.locator.busdox.timeout"));
        try {
            GOOGLE_PRIMARY_DNS = InetAddress.getByAddress(new byte[]{8, 8, 8, 8});
            GOOGLE_SECONDARY_DNS = InetAddress.getByAddress(new byte[]{8, 8, 4, 4});
            CLOUDFLARE_PRIMARY_DNS = InetAddress.getByAddress(new byte[]{1, 1, 1, 1});
            CLOUDFLARE_SECONDARY_DNS = InetAddress.getByAddress(new byte[]{1, 0, 0, 1});
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        customDNSServers.add(GOOGLE_PRIMARY_DNS);
        customDNSServers.add(GOOGLE_SECONDARY_DNS);
        customDNSServers.add(CLOUDFLARE_PRIMARY_DNS);
        customDNSServers.add(CLOUDFLARE_SECONDARY_DNS);
    }

    public BusdoxLocator(String hostname) {
        this("B-", hostname, "MD5");
    }

    public BusdoxLocator(String prefix, String hostname, String algorithm) {
        this.hostnameGenerator = new DynamicHostnameGenerator(prefix, hostname, algorithm);
    }

    @Override
    public URI lookup(ParticipantIdentifier participantIdentifier) throws LookupException {
        String hostname = this.hostnameGenerator.generate(participantIdentifier);
        try {
            ExtendedResolver extendedResolver = CustomExtendedDNSResolver.createExtendedResolver(customDNSServers, this.timeout, this.maxRetries);
            extendedResolver.setRetries(this.maxRetries);
            extendedResolver.setTimeout(Duration.ofSeconds(this.timeout));
            Lookup lookup2 = new Lookup(hostname);
            lookup2.setResolver(extendedResolver);
            int retryCountLeft = this.maxRetries;
            do {
                lookup2.run();
            } while (lookup2.getResult() == 2 && --retryCountLeft >= 0);
            if (lookup2.getResult() == 2) {
                extendedResolver.setTCP(true);
                retryCountLeft = this.maxRetries;
                do {
                    lookup2.run();
                } while (lookup2.getResult() == 2 && --retryCountLeft >= 0);
            }
            if (lookup2.getResult() != 0) {
                switch (lookup2.getResult()) {
                    case 3: 
                    case 4: {
                        throw new NotFoundException(String.format("Identifier '%s' is not registered in SML.", participantIdentifier.getIdentifier()));
                    }
                }
                throw new LookupException(String.format("Error when looking up identifier '%s' in SML. DNS-Lookup-Err: %s", participantIdentifier.getIdentifier(), lookup2.getErrorString()));
            }
        }
        catch (TextParseException e) {
            throw new LookupException(e.getMessage(), e);
        }
        return URI.create(String.format("http://%s", hostname));
    }
}

