/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.locator;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SimpleResolver;

public class CustomExtendedDNSResolver {
    private CustomExtendedDNSResolver() {
    }

    public static void setCustomizeResolverTimeout(Resolver resolver, long timeout) {
        resolver.setTimeout(Duration.ofSeconds(timeout));
    }

    public static void setCustomizeResolverTimeoutAndMaxRetries(ExtendedResolver extendedResolver, long timeout, int maxRetries) {
        CustomExtendedDNSResolver.setCustomizeResolverTimeout((Resolver)extendedResolver, timeout);
        extendedResolver.setRetries(maxRetries);
    }

    public static void iterateEachDefaultResolverAndConfigure(Consumer<? super SimpleResolver> consumer, long timeout) {
        for (InetSocketAddress inetSocketAddress : ResolverConfig.getCurrentConfig().servers()) {
            if (inetSocketAddress == null) continue;
            SimpleResolver simpleResolver = new SimpleResolver(inetSocketAddress);
            CustomExtendedDNSResolver.setCustomizeResolverTimeout((Resolver)simpleResolver, timeout);
            consumer.accept((SimpleResolver)simpleResolver);
        }
    }

    public static void iterateEachResolverAndConfigure(Iterable<? extends InetAddress> customDNSServersAddress, Consumer<? super SimpleResolver> aConsumer, long timeout) {
        if (customDNSServersAddress != null) {
            for (InetAddress inetAddress : customDNSServersAddress) {
                if (inetAddress == null) continue;
                SimpleResolver simpleResolver = new SimpleResolver(inetAddress);
                CustomExtendedDNSResolver.setCustomizeResolverTimeout((Resolver)simpleResolver, timeout);
                aConsumer.accept((SimpleResolver)simpleResolver);
            }
        }
    }

    private static boolean isResolverAlreadyAvailable(List<Resolver> resolverList, SimpleResolver simpleResolver) {
        InetSocketAddress aSearchAddr = simpleResolver.getAddress();
        return resolverList.stream().filter(x -> x instanceof SimpleResolver).map(x -> (SimpleResolver)x).anyMatch(x -> x.getAddress().equals(aSearchAddr));
    }

    public static ExtendedResolver createExtendedResolver(Iterable<? extends InetAddress> customDNSServersAddress, long timeout, int maxRetries) {
        ArrayList resolverList = new ArrayList();
        CustomExtendedDNSResolver.iterateEachResolverAndConfigure(customDNSServersAddress, x -> {
            if (!CustomExtendedDNSResolver.isResolverAlreadyAvailable(resolverList, x)) {
                resolverList.add(x);
            }
        }, timeout);
        CustomExtendedDNSResolver.iterateEachDefaultResolverAndConfigure(x -> {
            if (!CustomExtendedDNSResolver.isResolverAlreadyAvailable(resolverList, x)) {
                resolverList.add(x);
            }
        }, timeout);
        ExtendedResolver extendedResolver = new ExtendedResolver(resolverList);
        CustomExtendedDNSResolver.setCustomizeResolverTimeoutAndMaxRetries(extendedResolver, timeout, maxRetries);
        return extendedResolver;
    }
}

