/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.locator;

import com.google.common.io.BaseEncoding;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.api.NotFoundException;
import network.oxalis.vefa.peppol.lookup.locator.AbstractLocator;
import network.oxalis.vefa.peppol.lookup.locator.CustomExtendedDNSResolver;
import network.oxalis.vefa.peppol.lookup.util.DynamicHostnameGenerator;
import network.oxalis.vefa.peppol.lookup.util.EncodingUtils;
import network.oxalis.vefa.peppol.mode.Mode;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

public class BdxlLocator
extends AbstractLocator {
    private long timeout = 30L;
    private int maxRetries = 3;
    private static final List<InetAddress> customDNSServers = new ArrayList<InetAddress>();
    public static InetAddress GOOGLE_PRIMARY_DNS;
    public static InetAddress GOOGLE_SECONDARY_DNS;
    public static InetAddress CLOUDFLARE_PRIMARY_DNS;
    public static InetAddress CLOUDFLARE_SECONDARY_DNS;
    private final DynamicHostnameGenerator hostnameGenerator;

    public BdxlLocator(Mode mode) {
        this(mode.getString("lookup.locator.bdxl.prefix"), mode.getString("lookup.locator.hostname"), mode.getString("lookup.locator.bdxl.algorithm"), EncodingUtils.get(mode.getString("lookup.locator.bdxl.encoding")));
        this.maxRetries = Integer.parseInt(mode.getString("lookup.locator.bdxl.maxRetries"));
        this.timeout = Long.parseLong(mode.getString("lookup.locator.bdxl.timeout"));
        try {
            GOOGLE_PRIMARY_DNS = InetAddress.getByAddress(new byte[]{8, 8, 8, 8});
            GOOGLE_SECONDARY_DNS = InetAddress.getByAddress(new byte[]{8, 8, 4, 4});
            CLOUDFLARE_PRIMARY_DNS = InetAddress.getByAddress(new byte[]{1, 1, 1, 1});
            CLOUDFLARE_SECONDARY_DNS = InetAddress.getByAddress(new byte[]{1, 0, 0, 1});
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        customDNSServers.add(GOOGLE_PRIMARY_DNS);
        customDNSServers.add(GOOGLE_SECONDARY_DNS);
        customDNSServers.add(CLOUDFLARE_PRIMARY_DNS);
        customDNSServers.add(CLOUDFLARE_SECONDARY_DNS);
    }

    public BdxlLocator(String hostname) {
        this(hostname, "SHA-256");
    }

    public BdxlLocator(String hostname, String digestAlgorithm) {
        this("", hostname, digestAlgorithm);
    }

    public BdxlLocator(String prefix, String hostname, String digestAlgorithm) {
        this(prefix, hostname, digestAlgorithm, BaseEncoding.base32());
    }

    public BdxlLocator(String prefix, String hostname, String digestAlgorithm, BaseEncoding encoding) {
        this.hostnameGenerator = new DynamicHostnameGenerator(prefix, hostname, digestAlgorithm, encoding);
    }

    @Override
    public URI lookup(ParticipantIdentifier participantIdentifier) throws LookupException {
        String hostname = this.hostnameGenerator.generate(participantIdentifier).replaceAll("=*", "");
        try {
            Record[] records;
            ExtendedResolver extendedResolver = CustomExtendedDNSResolver.createExtendedResolver(customDNSServers, this.timeout, this.maxRetries);
            extendedResolver.setRetries(this.maxRetries);
            extendedResolver.setTimeout(Duration.ofSeconds(this.timeout));
            Lookup naptrLookup = new Lookup(hostname, 35);
            naptrLookup.setResolver(extendedResolver);
            int retryCountLeft = this.maxRetries;
            do {
                records = naptrLookup.run();
            } while (naptrLookup.getResult() == 2 && --retryCountLeft >= 0);
            if (naptrLookup.getResult() == 2) {
                extendedResolver.setTCP(true);
                retryCountLeft = this.maxRetries;
                do {
                    records = naptrLookup.run();
                } while (naptrLookup.getResult() == 2 && --retryCountLeft >= 0);
            }
            if (naptrLookup.getResult() != 0) {
                switch (naptrLookup.getResult()) {
                    case 3: 
                    case 4: {
                        throw new NotFoundException(String.format("Identifier '%s' is not registered in SML.", participantIdentifier.getIdentifier()));
                    }
                }
                throw new LookupException(String.format("Error when looking up identifier '%s' in SML. DNS-Lookup-Err: %s", participantIdentifier.getIdentifier(), naptrLookup.getErrorString()));
            }
            for (Record record : records) {
                String result;
                NAPTRRecord naptrRecord = (NAPTRRecord)record;
                if (!"Meta:SMP".equals(naptrRecord.getService()) || !"U".equalsIgnoreCase(naptrRecord.getFlags()) || (result = BdxlLocator.handleRegex(naptrRecord.getRegexp(), hostname)) == null) continue;
                return URI.create(result);
            }
        }
        catch (TextParseException e) {
            throw new LookupException("Error when handling DNS lookup for BDXL.", e);
        }
        throw new NotFoundException("Record for SMP not found in SML.");
    }

    public static String handleRegex(String naptrRegex, String hostname) {
        String[] regexp = naptrRegex.split("!");
        if (".*".equals(regexp[1])) {
            return regexp[2];
        }
        Pattern pattern = Pattern.compile(regexp[1]);
        Matcher matcher = pattern.matcher(hostname);
        if (matcher.matches()) {
            return matcher.replaceAll(regexp[2].replaceAll("\\\\{2}", "\\$"));
        }
        return null;
    }
}

