/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.sbdh;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import network.oxalis.peppol.sbdh.jaxb.BusinessScope;
import network.oxalis.peppol.sbdh.jaxb.ObjectFactory;
import network.oxalis.peppol.sbdh.jaxb.Partner;
import network.oxalis.peppol.sbdh.jaxb.PartnerIdentification;
import network.oxalis.peppol.sbdh.jaxb.Scope;
import network.oxalis.peppol.sbdh.jaxb.StandardBusinessDocument;
import network.oxalis.peppol.sbdh.jaxb.StandardBusinessDocumentHeader;
import network.oxalis.vefa.peppol.common.lang.PeppolRuntimeException;
import network.oxalis.vefa.peppol.common.model.ArgumentIdentifier;
import network.oxalis.vefa.peppol.common.model.C1CountryIdentifier;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.util.ExceptionUtil;

interface SbdhHelper {
    public static final JAXBContext JAXB_CONTEXT = (JAXBContext)ExceptionUtil.perform(PeppolRuntimeException.class, () -> JAXBContext.newInstance((Class[])new Class[]{StandardBusinessDocument.class, StandardBusinessDocumentHeader.class}));
    public static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    public static final XMLInputFactory XML_INPUT_FACTORY = (XMLInputFactory)ExceptionUtil.perform(PeppolRuntimeException.class, () -> {
        XMLInputFactory factory = XMLInputFactory.newFactory();
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return factory;
    });
    public static final XMLOutputFactory XML_OUTPUT_FACTORY = XMLOutputFactory.newFactory();
    public static final DatatypeFactory DATATYPE_FACTORY = (DatatypeFactory)ExceptionUtil.perform(PeppolRuntimeException.class, () -> DatatypeFactory.newInstance());

    public static Partner createPartner(ParticipantIdentifier participant) {
        PartnerIdentification partnerIdentification = new PartnerIdentification();
        partnerIdentification.setAuthority(participant.getScheme().getIdentifier());
        partnerIdentification.setValue(participant.getIdentifier());
        Partner partner = new Partner();
        partner.setIdentifier(partnerIdentification);
        return partner;
    }

    public static BusinessScope createBusinessScope(List<Scope> scopes) {
        BusinessScope businessScope = new BusinessScope();
        businessScope.getScope().addAll(scopes);
        return businessScope;
    }

    public static Scope createScope(ProcessIdentifier processIdentifier) {
        Scope scope = new Scope();
        scope.setType("PROCESSID");
        scope.setInstanceIdentifier(processIdentifier.getIdentifier());
        if (!processIdentifier.getScheme().equals(ProcessIdentifier.DEFAULT_SCHEME)) {
            scope.setIdentifier(processIdentifier.getScheme().getIdentifier());
        }
        return scope;
    }

    public static Scope createScope(C1CountryIdentifier c1CountryIdentifier) {
        Scope scope = new Scope();
        scope.setType("COUNTRY_C1");
        scope.setInstanceIdentifier(c1CountryIdentifier.getIdentifier());
        return scope;
    }

    public static Scope createScope(DocumentTypeIdentifier documentTypeIdentifier) {
        Scope scope = new Scope();
        scope.setType("DOCUMENTID");
        scope.setInstanceIdentifier(documentTypeIdentifier.getIdentifier());
        if (!documentTypeIdentifier.getScheme().equals(DocumentTypeIdentifier.BUSDOX_DOCID_QNS_SCHEME)) {
            scope.setIdentifier(documentTypeIdentifier.getScheme().getIdentifier());
        }
        return scope;
    }

    public static Scope createScope(ArgumentIdentifier argumentIdentifier) {
        Scope scope = new Scope();
        scope.setType(argumentIdentifier.getKey());
        scope.setInstanceIdentifier(argumentIdentifier.getIdentifier());
        return scope;
    }

    public static XMLGregorianCalendar toXmlGregorianCalendar(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        return DATATYPE_FACTORY.newXMLGregorianCalendar(c);
    }

    public static Date fromXMLGregorianCalendar(XMLGregorianCalendar calendar) {
        return calendar.toGregorianCalendar().getTime();
    }
}

