/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.security.xmldsig;

import java.security.cert.X509Certificate;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;
import network.oxalis.vefa.peppol.security.xmldsig.X509KeySelector;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class XmldsigVerifier {
    public static X509Certificate verify(Document document) throws PeppolSecurityException {
        try {
            NodeList nl = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                throw new PeppolSecurityException("Cannot find Signature element");
            }
            X509KeySelector keySelector = new X509KeySelector();
            DOMValidateContext valContext = new DOMValidateContext(keySelector, nl.item(0));
            XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM");
            XMLSignature signature = xmlSignatureFactory.unmarshalXMLSignature(valContext);
            if (!signature.validate(valContext)) {
                throw new PeppolSecurityException("Signature failed.");
            }
            return keySelector.getCertificate();
        }
        catch (MarshalException | XMLSignatureException e) {
            throw new PeppolSecurityException("Unable to verify document signature.", e);
        }
    }

    XmldsigVerifier() {
    }
}

