/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.statistics.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.inject.Inject;
import network.oxalis.persistence.annotation.Repository;
import network.oxalis.persistence.api.JdbcTxManager;
import network.oxalis.statistics.api.RawStatistics;
import network.oxalis.statistics.api.StatisticsGranularity;
import network.oxalis.statistics.jdbc.RawStatisticsRepositoryJdbcImpl;
import network.oxalis.statistics.util.DataSourceHelper;

@Repository
public class RawStatisticsRepositoryOracleImpl
extends RawStatisticsRepositoryJdbcImpl {
    @Inject
    public RawStatisticsRepositoryOracleImpl(JdbcTxManager jdbcTxManager) {
        super(jdbcTxManager);
    }

    @Override
    public Integer persist(RawStatistics rawStatistics) {
        Connection con = null;
        Integer result = 0;
        try {
            con = this.jdbcTxManager.getConnection();
            String sqlStatement = this.getPersistSqlQueryText();
            PreparedStatement ps = con.prepareStatement(sqlStatement, new String[]{"id"});
            ps.setString(1, rawStatistics.getAccessPointIdentifier().toString());
            ps.setTimestamp(2, new Timestamp(rawStatistics.getDate().getTime()));
            ps.setString(3, rawStatistics.getDirection().toString());
            ps.setString(4, rawStatistics.getSender().getIdentifier());
            ps.setString(5, rawStatistics.getReceiver().getIdentifier());
            ps.setString(6, rawStatistics.getDocumentTypeIdentifier().toString());
            ps.setString(7, rawStatistics.getProcessIdentifier().toString());
            ps.setString(8, rawStatistics.getChannelId() == null ? null : rawStatistics.getChannelId().stringValue());
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            if (rs.next()) {
                result = rs.getInt(1);
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unable to execute statement " + String.valueOf(e), e);
        }
        finally {
            DataSourceHelper.close(con);
        }
        return result;
    }

    @Override
    String getPersistSqlQueryText() {
        return String.format("INSERT INTO %s (ap, tstamp,  direction, sender, receiver, doc_type, profile, channel) values (?,?,?,?,?,?,?,?)", "raw_stats");
    }

    @Override
    String getRawStatisticsSqlQueryText(StatisticsGranularity granularity) {
        String dateFormatWithSelectedGranularity = this.oracleDateFormat(granularity);
        return "SELECT\n  ap,\n  'OUT' direction,\n  TO_CHAR(tstamp,'" + dateFormatWithSelectedGranularity + "') period,\n  sender ppid,\n  doc_type,\n  profile,\n  channel,\n  COUNT(*) count\nFROM\n  raw_stats\nWHERE\n  direction = 'OUT'\n  and tstamp between ? and ?\nGROUP BY 1,2,3,4,5,6,7\nunion\nSELECT\n  ap,\n  'IN' direction,\n  TO_CHAR(tstamp,'" + dateFormatWithSelectedGranularity + "') period,\n  receiver ppid,\n  doc_type,\n  profile,\n  channel,\n  COUNT(*) count\nFROM\n  raw_stats\nWHERE\n  direction = 'IN'\n  and tstamp between ? and ?\n\nGROUP BY 1,2,3,4,5,6,7\norder by period, ap\n";
    }

    private String oracleDateFormat(StatisticsGranularity granularity) {
        switch (granularity) {
            case YEAR: {
                return "YYYY";
            }
            case MONTH: {
                return "YYYY-MM";
            }
            case DAY: {
                return "YYYY-MM-DD";
            }
            case HOUR: {
                return "YYYY-MM-DDT%HH24";
            }
        }
        throw new IllegalArgumentException(String.format("Unable to convert '%s' into a Oracle date format string.", new Object[]{granularity}));
    }
}

