/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.util;

import com.google.common.io.ByteStreams;
import com.sun.mail.util.LineOutputStream;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import network.oxalis.api.lang.OxalisSecurityException;
import network.oxalis.as2.lang.OxalisAs2Exception;
import network.oxalis.commons.bouncycastle.BCHelper;
import network.oxalis.commons.security.CertificateUtils;
import network.oxalis.vefa.peppol.common.code.Service;
import network.oxalis.vefa.peppol.security.api.CertificateValidator;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.mail.smime.SMIMESigned;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.CollectionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedMessage {
    private static final Logger log = LoggerFactory.getLogger(SignedMessage.class);
    private static final Session SESSION = Session.getDefaultInstance(System.getProperties());
    private MimeMultipart mimeMultipart;
    private SMIMESigned smimeSigned;
    private byte[] signature;
    private String micalg;
    private X509Certificate signer;
    private byte[] digest;

    public static SignedMessage load(InputStream inputStream) throws IOException, MessagingException, OxalisAs2Exception {
        return new SignedMessage(new MimeMessage(SESSION, inputStream));
    }

    public static SignedMessage load(MimeMessage mimeMessage) throws IOException, OxalisAs2Exception {
        return new SignedMessage(mimeMessage);
    }

    private SignedMessage(MimeMessage message) throws IOException, OxalisAs2Exception {
        try {
            if (!message.isMimeType("multipart/signed")) {
                throw new OxalisAs2Exception("Received content is not 'multipart/signed'.");
            }
            this.micalg = SignedMessage.extractMicalg(message);
            this.mimeMultipart = (MimeMultipart)message.getContent();
            this.signature = ByteStreams.toByteArray(this.mimeMultipart.getBodyPart(1).getInputStream());
            this.smimeSigned = new SMIMESigned(this.mimeMultipart);
        }
        catch (MessagingException | CMSException e) {
            throw new OxalisAs2Exception("Unable to parse received content.", e);
        }
    }

    public InputStream getContent() throws IOException, OxalisSecurityException, OxalisAs2Exception {
        try {
            if (this.signer == null) {
                throw new OxalisSecurityException("Content is not validated.");
            }
            return this.smimeSigned.getContent().getInputStream();
        }
        catch (MessagingException e) {
            throw new OxalisAs2Exception("Unable to fetch content.", e);
        }
    }

    public byte[] getContentBytes() throws IOException, OxalisSecurityException, OxalisAs2Exception {
        return ByteStreams.toByteArray(this.getContent());
    }

    public String getMicalg() {
        return this.micalg;
    }

    public X509Certificate getSigner() {
        return this.signer;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getBodyHeader() throws IOException, OxalisAs2Exception {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            LineOutputStream los = new LineOutputStream(outputStream);
            Enumeration<String> hdrLines = ((MimeBodyPart)this.mimeMultipart.getBodyPart(0)).getNonMatchingHeaderLines(new String[0]);
            while (hdrLines.hasMoreElements()) {
                los.writeln(hdrLines.nextElement());
            }
            los.writeln();
            los.close();
            return outputStream.toByteArray();
        }
        catch (MessagingException e) {
            throw new OxalisAs2Exception("Unable to fetch body headers.", e);
        }
    }

    public void validate(X509Certificate certificate) throws OxalisSecurityException, PeppolSecurityException {
        try {
            SignerInformationVerifier verifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(certificate.getPublicKey());
            for (SignerInformation signerInformation : this.smimeSigned.getSignerInfos().getSigners()) {
                if (!signerInformation.verify(verifier)) continue;
                this.signer = certificate;
                this.digest = signerInformation.getContentDigest();
                return;
            }
        }
        catch (CMSException e) {
            throw new OxalisSecurityException(e.getMessage(), e);
        }
        catch (OperatorCreationException e) {
            throw new OxalisSecurityException("Unable to create SignerInformationVerifier.", e);
        }
        throw new PeppolSecurityException("Unable to verify signature.");
    }

    public void validate(Service service, CertificateValidator validator) throws IOException, OxalisSecurityException, PeppolSecurityException {
        this.validate(service, validator, null);
    }

    public void validate(Service service, CertificateValidator validator, String commonName) throws IOException, OxalisSecurityException, PeppolSecurityException {
        for (X509CertificateHolder holder : (CollectionStore)this.smimeSigned.getCertificates()) {
            if (!CertificateUtils.containsCommonName(holder.getSubject(), commonName)) continue;
            try {
                X509Certificate certificate = CertificateUtils.parseCertificate(holder.getEncoded());
                if (!this.isValid(service, validator, certificate)) continue;
                this.validate(certificate);
                return;
            }
            catch (CertificateException e) {
                log.debug("Unable to initiate certificate object.");
            }
        }
        throw new OxalisSecurityException(commonName == null ? "Unable to find valid certificate for validation of content." : String.format("Unable to find valid certificate with CN '%s' for validation of content.", commonName));
    }

    private boolean isValid(Service service, CertificateValidator validator, X509Certificate certificate) {
        try {
            validator.validate(service, certificate);
            return true;
        }
        catch (PeppolSecurityException e) {
            return false;
        }
    }

    public static String extractMicalg(MimeMessage message) throws OxalisAs2Exception {
        try {
            ContentType contentType = new ContentType(message.getContentType());
            String micalg = contentType.getParameter("micalg");
            if (micalg == null) {
                throw new OxalisAs2Exception("Parameter 'micalg' is not provided.");
            }
            return micalg;
        }
        catch (MessagingException e) {
            throw new OxalisAs2Exception("Unable to fetch content type.", e);
        }
    }

    static {
        BCHelper.registerProvider();
    }
}

