/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.outbound.lookup;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import network.oxalis.api.lang.OxalisTransmissionException;
import network.oxalis.api.lookup.LookupService;
import network.oxalis.api.settings.Settings;
import network.oxalis.api.util.Type;
import network.oxalis.outbound.lookup.LookupConf;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.lookup.LookupClient;

@Singleton
@Type(value={"cached"})
class CachedLookupService
extends CacheLoader<HeaderStub, Endpoint>
implements LookupService {
    private final LookupClient lookupClient;
    private final int pintWildcardMigrationPhase;
    private final TransportProfile[] transportProfiles;
    private final LoadingCache<HeaderStub, Endpoint> cache;

    @Inject
    public CachedLookupService(LookupClient lookupClient, Settings<LookupConf> settings, @Named(value="prioritized") List<TransportProfile> transportProfiles) {
        this.lookupClient = lookupClient;
        this.pintWildcardMigrationPhase = settings.getInt(LookupConf.PINT_WILDCARD_MIGRATION_PHASE);
        this.transportProfiles = transportProfiles.toArray(new TransportProfile[transportProfiles.size()]);
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build(this);
    }

    @Override
    public Endpoint lookup(Header header) throws OxalisTransmissionException {
        try {
            return this.cache.get(new HeaderStub(header));
        }
        catch (ExecutionException e) {
            throw new OxalisTransmissionException(e.getCause().getMessage(), e.getCause());
        }
    }

    @Override
    public Endpoint load(HeaderStub header) throws Exception {
        return this.lookupClient.getEndpoint(header.getReceiver(), header.getDocumentType(), header.getProcess(), this.pintWildcardMigrationPhase, this.transportProfiles);
    }

    static class HeaderStub {
        private ParticipantIdentifier receiver;
        private DocumentTypeIdentifier documentType;
        private ProcessIdentifier process;

        public HeaderStub(Header header) {
            this.receiver = header.getReceiver();
            this.documentType = header.getDocumentType();
            this.process = header.getProcess();
        }

        public ParticipantIdentifier getReceiver() {
            return this.receiver;
        }

        public DocumentTypeIdentifier getDocumentType() {
            return this.documentType;
        }

        public ProcessIdentifier getProcess() {
            return this.process;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HeaderStub that = (HeaderStub)o;
            return Objects.equals(this.receiver, that.receiver) && Objects.equals(this.documentType, that.documentType) && Objects.equals(this.process, that.process);
        }

        public int hashCode() {
            return Objects.hash(this.receiver, this.documentType, this.process);
        }
    }
}

