/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.spi.Message;
import com.google.inject.util.Modules;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import network.oxalis.api.lang.OxalisLoadingException;
import network.oxalis.commons.config.ConfigModule;
import network.oxalis.commons.filesystem.FileSystemModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceModuleLoader
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(GuiceModuleLoader.class);
    private static final String PREFIX = "oxalis.module";
    private static final String CLS = "class";
    private static final String ENABLED = "enabled";
    private static final String OVERRIDE = "override";
    private static final String DEPENDENCY = "dependency";

    public static Injector initiate(Module ... modules) {
        ArrayList<Module> moduleList = new ArrayList<Module>();
        moduleList.addAll(GuiceModuleLoader.getModules());
        moduleList.addAll(Arrays.asList(modules));
        try {
            return Guice.createInjector(moduleList);
        }
        catch (CreationException e) {
            if (e.getErrorMessages().stream().map(Message::getCause).allMatch(OxalisLoadingException.class::isInstance)) {
                e.getErrorMessages().stream().map(Message::getCause).filter(GuiceModuleLoader.distinctByKey(Throwable::getMessage)).forEach(c -> log.error(c.getMessage(), c));
                throw new OxalisLoadingException("Unable to load Oxalis due to errors during loading.");
            }
            throw e;
        }
    }

    protected void configure() {
        GuiceModuleLoader.getModules().forEach(arg_0 -> ((Binder)this.binder()).install(arg_0));
    }

    protected static List<Module> getModules() {
        Injector initialInjector = Guice.createInjector((Module[])new Module[]{new FileSystemModule(), new ConfigModule()});
        Config config = (Config)initialInjector.getInstance(Config.class);
        HashMap<String, Config> moduleConfigs = new HashMap<String, Config>();
        for (String group : config.getObject(PREFIX).keySet()) {
            for (String module : config.getObject(String.format("%s.%s", PREFIX, group)).keySet()) {
                Config moduleConfig = config.getConfig(String.format("%s.%s.%s", PREFIX, group, module));
                if (moduleConfig.hasPath(ENABLED) && !moduleConfig.getBoolean(ENABLED)) continue;
                moduleConfigs.put(String.format("%s.%s", group, module), moduleConfig);
            }
        }
        return moduleConfigs.values().stream().filter(mc -> !mc.hasPath(DEPENDENCY) || moduleConfigs.containsKey(mc.getString(DEPENDENCY))).map(GuiceModuleLoader::load).collect(Collectors.toList());
    }

    protected static Module load(Config config) {
        if (config.hasPath(OVERRIDE)) {
            log.debug("Loading module '{}' with override.", (Object)config.getString(CLS));
            return Modules.override((Module[])new Module[]{GuiceModuleLoader.loadModule(config.getString(CLS))}).with(new Module[]{GuiceModuleLoader.loadModule(config.getString(OVERRIDE))});
        }
        log.debug("Loading module '{}'.", (Object)config.getString(CLS));
        return GuiceModuleLoader.loadModule(config.getString(CLS));
    }

    protected static Module loadModule(String className) {
        try {
            return (Module)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new OxalisLoadingException(e.getMessage(), (Throwable)e);
        }
    }

    protected static <T, R> Predicate<T> distinctByKey(Function<? super T, R> function) {
        HashSet set = new HashSet();
        return t -> set.add(function.apply(t));
    }
}

