/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.apachehttpclient.v4_3;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.ApacheHttpClientRequest;
import io.opentelemetry.instrumentation.apachehttpclient.v4_3.HttpHeaderSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientRequestResendCount;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;

final class TracingProtocolExec
implements ClientExecChain {
    private static final String REQUEST_PARENT_CONTEXT_ATTRIBUTE_ID = TracingProtocolExec.class.getName() + ".context";
    private final Instrumenter<ApacheHttpClientRequest, HttpResponse> instrumenter;
    private final ContextPropagators propagators;
    private final ClientExecChain exec;

    TracingProtocolExec(Instrumenter<ApacheHttpClientRequest, HttpResponse> instrumenter, ContextPropagators propagators, ClientExecChain exec) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
        this.exec = exec;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext httpContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        ApacheHttpClientRequest instrumenterRequest;
        Context parentContext = httpContext.getAttribute(REQUEST_PARENT_CONTEXT_ATTRIBUTE_ID, Context.class);
        if (parentContext == null) {
            parentContext = HttpClientRequestResendCount.initialize(Context.current());
            httpContext.setAttribute(REQUEST_PARENT_CONTEXT_ATTRIBUTE_ID, parentContext);
        }
        HttpHost host = null;
        if (route.getTargetHost() != null) {
            host = route.getTargetHost();
        } else if (httpContext.getTargetHost() != null) {
            host = httpContext.getTargetHost();
        }
        if (host != null && (host.getSchemeName().equals("https") && host.getPort() == 443 || host.getSchemeName().equals("http") && host.getPort() == 80)) {
            host = new HttpHost(host.getHostName(), -1, host.getSchemeName());
        }
        if (!this.instrumenter.shouldStart(parentContext, instrumenterRequest = new ApacheHttpClientRequest(host, request))) {
            return this.exec.execute(route, request, httpContext, httpExecutionAware);
        }
        Context context = this.instrumenter.start(parentContext, instrumenterRequest);
        this.propagators.getTextMapPropagator().inject(context, request, HttpHeaderSetter.INSTANCE);
        return this.execute(route, request, instrumenterRequest, httpContext, httpExecutionAware, context);
    }

    private CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, ApacheHttpClientRequest instrumenterRequest, HttpClientContext httpContext, HttpExecutionAware httpExecutionAware, Context context) throws IOException, HttpException {
        CloseableHttpResponse response = null;
        Throwable error = null;
        Scope ignored = context.makeCurrent();
        try {
            CloseableHttpResponse closeableHttpResponse = response = this.exec.execute(route, request, httpContext, httpExecutionAware);
            if (ignored != null) {
                ignored.close();
            }
            this.instrumenter.end(context, instrumenterRequest, response, error);
            return closeableHttpResponse;
        }
        catch (Throwable throwable) {
            try {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    error = e;
                    throw e;
                }
            }
            catch (Throwable throwable3) {
                this.instrumenter.end(context, instrumenterRequest, response, error);
                throw throwable3;
            }
        }
    }
}

