/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.util;

import java.security.NoSuchAlgorithmException;
import network.oxalis.vefa.peppol.common.code.DigestMethod;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;

public enum SMimeDigestMethod {
    sha1(new String[]{"sha1", "sha-1", "rsa-sha1"}, "SHA1withRSA", "SHA-1", OIWObjectIdentifiers.idSHA1, DigestMethod.SHA1, TransportProfile.PEPPOL_AS2_1_0),
    sha256(new String[]{"sha256", "sha-256"}, "SHA256withRSA", "SHA-256", NISTObjectIdentifiers.id_sha256, DigestMethod.SHA256, TransportProfile.PEPPOL_AS2_2_0),
    sha512(new String[]{"sha512", "sha-512"}, "SHA512withRSA", "SHA-512", NISTObjectIdentifiers.id_sha512, DigestMethod.SHA512, TransportProfile.of("busdox-transport-as2-ver1p0r1"));

    private final String[] identifier;
    private final String method;
    private final String algorithm;
    private final ASN1ObjectIdentifier oid;
    private final DigestMethod digestMethod;
    private final TransportProfile transportProfile;

    private SMimeDigestMethod(String[] identifier, String method, String algorithm, ASN1ObjectIdentifier oid, DigestMethod digestMethod, TransportProfile transportProfile) {
        this.identifier = identifier;
        this.method = method;
        this.algorithm = algorithm;
        this.oid = oid;
        this.digestMethod = digestMethod;
        this.transportProfile = transportProfile;
    }

    public String getIdentifier() {
        return this.identifier[0];
    }

    public String getMethod() {
        return this.method;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public TransportProfile getTransportProfile() {
        return this.transportProfile;
    }

    public static SMimeDigestMethod findByIdentifier(String identifier) throws NoSuchAlgorithmException {
        String provided = String.valueOf(identifier).toLowerCase();
        for (SMimeDigestMethod digestMethod : SMimeDigestMethod.values()) {
            for (String ident : digestMethod.identifier) {
                if (!ident.equals(provided)) continue;
                return digestMethod;
            }
        }
        throw new NoSuchAlgorithmException(String.format("Digest method '%s' not known.", identifier));
    }

    public static SMimeDigestMethod findByTransportProfile(TransportProfile transportProfile) {
        for (SMimeDigestMethod digestMethod : SMimeDigestMethod.values()) {
            if (!digestMethod.transportProfile.equals(transportProfile)) continue;
            return digestMethod;
        }
        throw new IllegalArgumentException(String.format("Digest method for transport profile '%s' not known.", transportProfile));
    }

    public static SMimeDigestMethod findByDigestMethod(DigestMethod digestMethod) {
        for (SMimeDigestMethod method : SMimeDigestMethod.values()) {
            if (!method.digestMethod.equals((Object)digestMethod)) continue;
            return method;
        }
        throw new IllegalArgumentException(String.format("Digest method '%s' not known.", new Object[]{digestMethod}));
    }
}

