/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.mode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.typesafe.config.Config;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import network.oxalis.api.lang.OxalisLoadingException;
import network.oxalis.commons.certvalidator.api.CrlFetcher;
import network.oxalis.pkix.ocsp.api.OcspFetcher;
import network.oxalis.vefa.peppol.common.lang.PeppolLoadingException;
import network.oxalis.vefa.peppol.mode.Mode;
import network.oxalis.vefa.peppol.security.ModeDetector;

public class ModeProvider
implements Provider<Mode> {
    @Inject
    private X509Certificate certificate;
    @Inject
    private Config config;
    @Inject
    private OcspFetcher ocspFetcher;
    @Inject
    private CrlFetcher crlFetcher;
    @Inject
    private Tracer tracer;

    @Override
    public Mode get() {
        Span span = this.tracer.spanBuilder("Mode detection").startSpan();
        try {
            HashMap<String, Object> objectStorage = new HashMap<String, Object>();
            objectStorage.put("ocsp_fetcher", this.ocspFetcher);
            objectStorage.put("crlFetcher", this.crlFetcher);
            Mode mode = ModeDetector.detect(this.certificate, this.config, objectStorage);
            return mode;
        }
        catch (PeppolLoadingException e) {
            throw new OxalisLoadingException("Unable to detect mode.", e);
        }
        finally {
            span.end();
        }
    }
}

