/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.common.model;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;
import network.oxalis.vefa.peppol.common.api.PotentiallySigned;

public class Signed<T>
implements PotentiallySigned<T>,
Serializable {
    private static final long serialVersionUID = 4872358438639447851L;
    private final T content;
    private final X509Certificate certificate;
    private final Date timestamp;

    public static <T> Signed<T> of(T content, X509Certificate certificate, Date timestamp) {
        return new Signed<T>(content, certificate, timestamp);
    }

    public static <T> Signed<T> of(T content, X509Certificate certificate) {
        return Signed.of(content, certificate, null);
    }

    private Signed(T content, X509Certificate certificate, Date timestamp) {
        this.content = content;
        this.certificate = certificate;
        this.timestamp = timestamp;
    }

    @Override
    public T getContent() {
        return this.content;
    }

    @Override
    public <S> Signed<S> ofSubset(S s2) {
        return new Signed<S>(s2, this.certificate, this.timestamp);
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signed signed = (Signed)o;
        if (!this.content.equals(signed.content)) {
            return false;
        }
        if (!this.certificate.equals(signed.certificate)) {
            return false;
        }
        return !(this.timestamp == null ? signed.timestamp != null : !this.timestamp.equals(signed.timestamp));
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = 31 * result + this.certificate.hashCode();
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Signed{content=" + String.valueOf(this.content) + ", certificate=" + String.valueOf(this.certificate) + ", timestamp=" + String.valueOf(this.timestamp) + "}";
    }
}

