/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.pkix.ocsp.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import network.oxalis.pkix.ocsp.api.OcspFetcher;
import network.oxalis.pkix.ocsp.api.OcspFetcherResponse;
import network.oxalis.pkix.ocsp.builder.Builder;
import network.oxalis.pkix.ocsp.builder.Properties;
import network.oxalis.pkix.ocsp.builder.Property;
import network.oxalis.pkix.ocsp.fetcher.AbstractOcspFetcher;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.util.Timeout;

public class ApacheOcspFetcher
extends AbstractOcspFetcher {
    public static final Property<HttpClientConnectionManager> CONNECTION_MANAGER = Property.create();
    public static final Property<Boolean> CONNECTION_MANAGER_SHARED = Property.create(false);
    public static final Property<Integer> TIMEOUT_CONNECTION_MANAGER = Property.create(-1);

    public static Builder<OcspFetcher> builder() {
        return new Builder<OcspFetcher>(ApacheOcspFetcher::new);
    }

    private ApacheOcspFetcher(Properties properties) {
        super(properties);
    }

    @Override
    public OcspFetcherResponse fetch(URI uri, byte[] content) throws IOException {
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", (Object)"application/ocsp-request");
        httpPost.setHeader("Accept", (Object)"application/ocsp-response");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(content, ContentType.create((String)"application/ocsp-request")));
        return new ApacheOcspFetcherResponse(this.getHttpClient().execute((ClassicHttpRequest)httpPost));
    }

    protected CloseableHttpClient getHttpClient() {
        return HttpClients.custom().setConnectionManager(this.properties.get(CONNECTION_MANAGER)).setConnectionManagerShared(this.properties.get(CONNECTION_MANAGER_SHARED).booleanValue()).setDefaultRequestConfig(this.getRequestConfig()).build();
    }

    protected RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(this.getTimeout(TIMEOUT_CONNECT)).setResponseTimeout(this.getTimeout(TIMEOUT_READ)).setConnectionRequestTimeout(this.getTimeout(TIMEOUT_CONNECTION_MANAGER)).build();
    }

    private Timeout getTimeout(Property<Integer> timeoutProperty) {
        int timeoutValue = this.properties.get(timeoutProperty);
        return timeoutValue > 0 ? Timeout.ofMilliseconds((long)timeoutValue) : Timeout.DISABLED;
    }

    private static class ApacheOcspFetcherResponse
    implements OcspFetcherResponse {
        private final CloseableHttpResponse response;

        public ApacheOcspFetcherResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        @Override
        public int getStatus() {
            return this.response.getCode();
        }

        @Override
        public String getContentType() {
            return this.response.getFirstHeader("Content-Type").getValue();
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.response.getEntity().getContent();
        }

        @Override
        public void close() throws IOException {
            this.response.close();
        }
    }
}

