/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.provider;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.util.ModelUtils;
import network.oxalis.vefa.peppol.lookup.api.MetadataProvider;

public class DefaultProvider
implements MetadataProvider {
    private static final int SEPARATOR_LENGTH = 2;
    private static final String WILDCARD_INDICATOR_CHARACTER = "*";
    private static final String NARROWER_SCHEMEPART_INDICATOR_CHARACTER = "@";
    private static final String PINT_TEXT = "urn:peppol:pint:";

    @Override
    public List<URI> resolveDocumentIdentifiers(URI location, ParticipantIdentifier participant) {
        return List.of(location.resolve("/" + participant.urlencoded()));
    }

    @Override
    public List<URI> resolveServiceMetadata(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, int pintWildcardMigrationPhase) {
        ArrayList<URI> resolvedServiceMetaDataURIList = new ArrayList<URI>();
        String docSchemeIdentifier = documentTypeIdentifier.getScheme().getIdentifier();
        boolean isPintMessage = this.isItPINTMessage(documentTypeIdentifier);
        if ("busdox-docid-qns".equals(docSchemeIdentifier) && !isPintMessage) {
            this.addResolvedUri(location, participantIdentifier, documentTypeIdentifier, resolvedServiceMetaDataURIList);
        } else if (isPintMessage) {
            this.resolvePintExactMatchPriority(location, participantIdentifier, documentTypeIdentifier, pintWildcardMigrationPhase, resolvedServiceMetaDataURIList);
            if ("peppol-doctype-wildcard".equals(docSchemeIdentifier)) {
                this.processPintWildcards(location, participantIdentifier, documentTypeIdentifier, resolvedServiceMetaDataURIList);
            }
        }
        return resolvedServiceMetaDataURIList;
    }

    private boolean isItPINTMessage(DocumentTypeIdentifier documentTypeIdentifier) {
        return this.getCustomizationIdentifier(documentTypeIdentifier).toLowerCase().contains(PINT_TEXT);
    }

    private String getCustomizationIdentifier(DocumentTypeIdentifier documentTypeIdentifier) {
        String instanceId = documentTypeIdentifier.getIdentifier();
        int startIdx = instanceId.indexOf("##") + 2;
        int endIdx = instanceId.lastIndexOf("::");
        return instanceId.substring(startIdx, endIdx);
    }

    private void resolvePintExactMatchPriority(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, int phase, List<URI> resolvedServiceMetaDataURIList) {
        String docScheme = documentTypeIdentifier.getScheme().getIdentifier();
        if (phase == 0 && "busdox-docid-qns".equals(docScheme)) {
            this.addResolvedUri(location, participantIdentifier, documentTypeIdentifier, resolvedServiceMetaDataURIList);
        } else if (phase == 1 && ("peppol-doctype-wildcard".equals(docScheme) || "busdox-docid-qns".equals(docScheme))) {
            this.addResolvedUri(location, participantIdentifier, documentTypeIdentifier, resolvedServiceMetaDataURIList);
        } else if (phase >= 2 && "peppol-doctype-wildcard".equals(docScheme)) {
            this.addResolvedUri(location, participantIdentifier, documentTypeIdentifier, resolvedServiceMetaDataURIList);
        }
    }

    private void processPintWildcards(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, List<URI> resolvedServiceMetaDataURIList) {
        String instanceId = documentTypeIdentifier.getIdentifier();
        int startIdx = instanceId.indexOf("##") + 2;
        int endIdx = instanceId.lastIndexOf("::");
        String syntaxId = instanceId.substring(0, startIdx - 2);
        String customizationId = instanceId.substring(startIdx, endIdx);
        String version = instanceId.substring(endIdx + 2);
        this.addWildcardUris(location, participantIdentifier, documentTypeIdentifier.getScheme().getIdentifier(), syntaxId, customizationId, version, resolvedServiceMetaDataURIList);
    }

    private void addWildcardUris(URI location, ParticipantIdentifier participantIdentifier, String docScheme, String syntaxId, String customizationId, String version, List<URI> resolvedServiceMetaDataURIList) {
        while (!customizationId.isEmpty()) {
            String urlEncoded = ModelUtils.urlencode((String)"%s::%s##%s::%s", (String[])new String[]{docScheme, syntaxId, customizationId + WILDCARD_INDICATOR_CHARACTER, version});
            resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), urlEncoded)));
            int lastIdx = customizationId.lastIndexOf(NARROWER_SCHEMEPART_INDICATOR_CHARACTER);
            if (lastIdx == -1) break;
            customizationId = customizationId.substring(0, lastIdx);
        }
    }

    private void addResolvedUri(URI location, ParticipantIdentifier participantIdentifier, DocumentTypeIdentifier documentTypeIdentifier, List<URI> resolvedServiceMetaDataURIList) {
        resolvedServiceMetaDataURIList.add(location.resolve(String.format("/%s/services/%s", participantIdentifier.urlencoded(), documentTypeIdentifier.urlencoded())));
    }
}

