/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.util;

import com.google.common.io.ByteStreams;
import jakarta.activation.DataHandler;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import network.oxalis.as2.util.SMimeDigestMethod;
import network.oxalis.commons.bouncycastle.BCHelper;
import network.oxalis.vefa.peppol.common.model.Digest;

public class MimeMessageHelper {
    private static final Session SESSION = Session.getDefaultInstance(System.getProperties(), null);

    public static MimeMessage parse(InputStream inputStream) throws MessagingException {
        return new MimeMessage(SESSION, inputStream);
    }

    public static MimeMessage parse(InputStream inputStream, InternetHeaders headers) throws MessagingException {
        return MimeMessageHelper.parse(inputStream, Collections.list(headers.getAllHeaderLines()).stream().map(String.class::cast));
    }

    public static MimeMessage parse(InputStream inputStream, Stream<String> headers) throws MessagingException {
        String headerString = headers.collect(Collectors.joining("\r\n")) + "\r\n\r\n";
        return MimeMessageHelper.parse(new SequenceInputStream(new ByteArrayInputStream(headerString.getBytes()), inputStream));
    }

    public static MimeBodyPart createMimeBodyPart(InputStream inputStream, String mimeType) {
        ByteArrayDataSource byteArrayDataSource;
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        try {
            byteArrayDataSource = new ByteArrayDataSource(inputStream, mimeType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create ByteArrayDataSource from inputStream." + e.getMessage(), e);
        }
        try {
            DataHandler dh = new DataHandler(byteArrayDataSource);
            mimeBodyPart.setDataHandler(dh);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Unable to set data handler on mime body part." + e.getMessage(), e);
        }
        try {
            mimeBodyPart.setHeader("Content-Type", mimeType);
            mimeBodyPart.setHeader("Content-Transfer-Encoding", "binary");
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Unable to set headers." + e.getMessage(), e);
        }
        return mimeBodyPart;
    }

    public static Digest calculateMic(MimeBodyPart bodyPart, SMimeDigestMethod digestMethod) {
        try {
            MessageDigest md = BCHelper.getMessageDigest(digestMethod.getIdentifier());
            bodyPart.writeTo(new DigestOutputStream(ByteStreams.nullOutputStream(), md));
            return Digest.of(digestMethod.getDigestMethod(), md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(digestMethod.getIdentifier() + " not found", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read data from digest input. " + e.getMessage(), e);
        }
        catch (MessagingException e) {
            throw new IllegalStateException("Unable to handle mime body part. " + e.getMessage(), e);
        }
    }

    public static byte[] toBytes(MimeMessage mimeMessage) {
        ByteArrayOutputStream evidenceBytes = new ByteArrayOutputStream();
        try {
            mimeMessage.writeTo(evidenceBytes);
        }
        catch (MessagingException | IOException e) {
            throw new IllegalStateException("Unable to convert MDN mime message into bytes()", e);
        }
        return evidenceBytes.toByteArray();
    }
}

