/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.outbound.transformer;

import jakarta.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import network.oxalis.api.lang.OxalisContentException;
import network.oxalis.api.transformer.ContentWrapper;
import network.oxalis.api.util.Type;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.sbdh.SbdWriter;
import network.oxalis.vefa.peppol.sbdh.lang.SbdhException;
import network.oxalis.vefa.peppol.sbdh.util.XMLStreamUtils;

@Singleton
@Type(value={"xml"})
public class XmlContentWrapper
implements ContentWrapper {
    @Override
    public InputStream wrap(InputStream inputStream, Header header) throws IOException, OxalisContentException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (SbdWriter sbdWriter = SbdWriter.newInstance(outputStream, header);){
            XMLStreamUtils.copy(inputStream, sbdWriter.xmlWriter());
        }
        catch (XMLStreamException | SbdhException e) {
            throw new OxalisContentException("Unable to wrap content into SBDH.", e);
        }
        return new ByteArrayInputStream(outputStream.toByteArray());
    }
}

