/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.sbdh;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.util.ExceptionUtil;
import network.oxalis.vefa.peppol.sbdh.Ns;
import network.oxalis.vefa.peppol.sbdh.SbdhHelper;
import network.oxalis.vefa.peppol.sbdh.SbdhWriter;
import network.oxalis.vefa.peppol.sbdh.lang.SbdhException;
import network.oxalis.vefa.peppol.sbdh.util.XMLBinaryOutputStream;
import network.oxalis.vefa.peppol.sbdh.util.XMLStreamWriterWrapper;
import network.oxalis.vefa.peppol.sbdh.util.XMLTextOutputStream;

public class SbdWriter
implements Closeable {
    private XMLStreamWriter writer = ExceptionUtil.perform(SbdhException.class, "Unable to initiate SBD.", () -> SbdhHelper.XML_OUTPUT_FACTORY.createXMLStreamWriter(outputStream, "UTF-8"));

    public static SbdWriter newInstance(OutputStream outputStream, Header header) throws SbdhException {
        return new SbdWriter(outputStream, header);
    }

    private SbdWriter(OutputStream outputStream, Header header) throws SbdhException {
        this.initiateDocument(header);
    }

    private void initiateDocument(Header header) throws SbdhException {
        ExceptionUtil.perform(SbdhException.class, () -> {
            this.writer.writeStartDocument("UTF-8", "1.0");
            this.writer.writeStartElement("", Ns.QNAME_SBD.getLocalPart(), "http://www.unece.org/cefact/namespaces/StandardBusinessDocumentHeader");
            this.writer.writeDefaultNamespace("http://www.unece.org/cefact/namespaces/StandardBusinessDocumentHeader");
            SbdhWriter.write(this.writer, header);
        });
    }

    public XMLStreamWriter xmlWriter() {
        return new XMLStreamWriterWrapper(this.writer);
    }

    public OutputStream binaryWriter(String mimeType) throws XMLStreamException {
        return this.binaryWriter(mimeType, null);
    }

    public OutputStream binaryWriter(String mimeType, String encoding) throws XMLStreamException {
        return new XMLBinaryOutputStream(this.xmlWriter(), mimeType, encoding);
    }

    public OutputStream textWriter(String mimeType) throws XMLStreamException {
        return new XMLTextOutputStream(this.xmlWriter(), mimeType);
    }

    private void finalizeDocument() throws SbdhException {
        ExceptionUtil.perform(SbdhException.class, () -> {
            this.writer.writeEndElement();
            this.writer.writeEndDocument();
        });
    }

    @Override
    public void close() throws IOException {
        ExceptionUtil.perform(IOException.class, () -> {
            this.finalizeDocument();
            this.writer.close();
        });
    }
}

