/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.outbound;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLHandshakeException;
import lombok.Generated;
import network.oxalis.api.identifier.MessageIdGenerator;
import network.oxalis.api.lang.OxalisTransmissionException;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.timestamp.TimestampProvider;
import network.oxalis.as2.model.As2DispositionNotificationOptions;
import network.oxalis.as2.util.As2DateUtil;
import network.oxalis.as2.util.MessageIdUtil;
import network.oxalis.as2.util.MimeMessageHelper;
import network.oxalis.as2.util.SMimeDigestMethod;
import network.oxalis.as2.util.SMimeMessageFactory;
import network.oxalis.commons.security.CertificateUtils;
import network.oxalis.commons.tracing.Traceable;
import network.oxalis.vefa.peppol.common.model.Digest;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class As2MessageSender
extends Traceable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(As2MessageSender.class);
    private final Provider<CloseableHttpClient> httpClientProvider;
    private final SMimeMessageFactory sMimeMessageFactory;
    private final TimestampProvider timestampProvider;
    private final String notificationAddress;
    private final MessageIdGenerator messageIdGenerator;
    private final String fromIdentifier;
    private TransmissionRequest transmissionRequest;
    private TransmissionIdentifier transmissionIdentifier;
    private Digest outboundMic;

    @Inject
    public As2MessageSender(Provider<CloseableHttpClient> httpClientProvider, X509Certificate certificate, SMimeMessageFactory sMimeMessageFactory, TimestampProvider timestampProvider, @Named(value="as2-notification") String notificationAddress, MessageIdGenerator messageIdGenerator, Tracer tracer) {
        super(tracer);
        this.httpClientProvider = httpClientProvider;
        this.sMimeMessageFactory = sMimeMessageFactory;
        this.timestampProvider = timestampProvider;
        this.notificationAddress = notificationAddress;
        this.messageIdGenerator = messageIdGenerator;
        this.fromIdentifier = CertificateUtils.extractCommonName(certificate);
    }

    public TransmissionResponse send(TransmissionRequest transmissionRequest) throws OxalisTransmissionException {
        this.transmissionRequest = transmissionRequest;
        Span root = this.tracer.spanBuilder("Send AS2 message").startSpan();
        try {
            TransmissionResponse transmissionResponse = this.sendHttpRequest(this.prepareHttpRequest());
            return transmissionResponse;
        }
        catch (OxalisTransmissionException e) {
            root.setAttribute("exception", e.getMessage());
            throw e;
        }
        finally {
            root.end();
        }
    }

    protected HttpPost prepareHttpRequest() throws OxalisTransmissionException {
        Span span = this.tracer.spanBuilder("request").startSpan();
        try {
            MimeBodyPart mimeBodyPart = MimeMessageHelper.createMimeBodyPart(this.transmissionRequest.getPayload(), "application/xml");
            SMimeDigestMethod digestMethod = SMimeDigestMethod.findByTransportProfile(this.transmissionRequest.getEndpoint().getTransportProfile());
            this.outboundMic = MimeMessageHelper.calculateMic(mimeBodyPart, digestMethod);
            span.setAttribute("mic", this.outboundMic.toString());
            span.setAttribute("endpoint url", this.transmissionRequest.getEndpoint().getAddress().toString());
            String messageId = this.messageIdGenerator.generate(this.transmissionRequest);
            if (!MessageIdUtil.verify(messageId)) {
                throw new OxalisTransmissionException("Invalid Message-ID '" + messageId + "' generated.");
            }
            span.setAttribute("message-id", messageId);
            this.transmissionIdentifier = TransmissionIdentifier.fromHeader(messageId);
            MimeMessage signedMimeMessage = this.sMimeMessageFactory.createSignedMimeMessage(mimeBodyPart, digestMethod);
            Map<String, String> headers = Collections.list(signedMimeMessage.getAllHeaders()).stream().collect(Collectors.toMap(Header::getName, h -> h.getValue().replace("\r\n\t", "")));
            for (String name : headers.keySet()) {
                signedMimeMessage.removeHeader(name);
            }
            HttpPost httpPost = new HttpPost(this.transmissionRequest.getEndpoint().getAddress());
            ByteArrayEntity httpEntity = new ByteArrayEntity(ByteStreams.toByteArray(signedMimeMessage.getInputStream()), ContentType.DEFAULT_BINARY);
            httpPost.setEntity(httpEntity);
            httpPost.addHeader("Message-Id", messageId);
            httpPost.addHeader("MIME-Version", headers.get("MIME-Version"));
            httpPost.addHeader("Content-Type", headers.get("Content-Type"));
            httpPost.addHeader("AS2-From", this.fromIdentifier);
            httpPost.setHeader("AS2-To", CertificateUtils.extractCommonName(this.transmissionRequest.getEndpoint().getCertificate()));
            httpPost.addHeader("Disposition-Notification-To", this.notificationAddress);
            httpPost.addHeader("Disposition-Notification-Options", As2DispositionNotificationOptions.getDefault(digestMethod).toString());
            httpPost.addHeader("AS2-Version", "1.0");
            httpPost.addHeader("Subject", "AS2 message from Oxalis");
            httpPost.addHeader("Date", As2DateUtil.RFC822.format(new Date()));
            HttpPost httpPost2 = httpPost;
            return httpPost2;
        }
        catch (MessagingException | IOException e) {
            throw new OxalisTransmissionException("Unexpected error during preparation of AS2 message.", (Throwable)e);
        }
        finally {
            span.end();
        }
    }

    protected TransmissionResponse sendHttpRequest(HttpPost httpPost) throws OxalisTransmissionException {
        Span span = this.tracer.spanBuilder("execute").startSpan();
        try {
            TransmissionResponse transmissionResponse;
            block14: {
                CloseableHttpClient httpClient = this.httpClientProvider.get();
                try {
                    BasicHttpContext basicHttpContext = new BasicHttpContext();
                    basicHttpContext.setAttribute(As2MessageSender.class.getName() + ".parentSpanContext", span.getSpanContext());
                    CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpPost, basicHttpContext);
                    transmissionResponse = this.handleResponse(response);
                    if (httpClient == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (httpClient != null) {
                            try {
                                httpClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SocketTimeoutException e) {
                        span.setAttribute("exception", String.valueOf(e.getMessage()));
                        throw new OxalisTransmissionException("Receiving server has not sent anything back within SOCKET_TIMEOUT", this.transmissionRequest.getEndpoint().getAddress(), e);
                    }
                    catch (HttpHostConnectException e) {
                        span.setAttribute("exception", e.getMessage());
                        throw new OxalisTransmissionException("Receiving server does not seem to be running.", this.transmissionRequest.getEndpoint().getAddress(), e);
                    }
                    catch (SSLHandshakeException e) {
                        span.setAttribute("exception", e.getMessage());
                        throw new OxalisTransmissionException("Possible invalid SSL Certificate at the other end.", this.transmissionRequest.getEndpoint().getAddress(), e);
                    }
                    catch (IOException e) {
                        span.setAttribute("exception", String.valueOf(e.getMessage()));
                        throw new OxalisTransmissionException(this.transmissionRequest.getEndpoint().getAddress(), (Throwable)e);
                    }
                }
                httpClient.close();
            }
            return transmissionResponse;
        }
        finally {
            span.end();
        }
    }

    /*
     * Exception decompiling
     */
    protected TransmissionResponse handleResponse(CloseableHttpResponse closeableHttpResponse) throws OxalisTransmissionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void handleFailedRequest(HttpResponse response) throws OxalisTransmissionException {
        ClassicHttpResponse classicResponse = (ClassicHttpResponse)response;
        HttpEntity entity = classicResponse.getEntity();
        try {
            if (entity == null) {
                throw new OxalisTransmissionException(String.format("Request failed with rc=%s, no content returned in HTTP response", response.getCode()));
            }
            String contents = EntityUtils.toString(entity);
            throw new OxalisTransmissionException(String.format("Request failed with rc=%s, contents received (%s characters): %s", response.getCode(), contents.trim().length(), contents));
        }
        catch (IOException | ParseException e) {
            throw new OxalisTransmissionException(String.format("Request failed with rc=%s, ERROR while retrieving the contents of the response: %s", response.getCode(), e.getMessage()), (Throwable)e);
        }
    }
}

