/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.icd;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import network.oxalis.vefa.peppol.common.lang.PeppolParsingException;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.Scheme;
import network.oxalis.vefa.peppol.icd.api.Icd;
import network.oxalis.vefa.peppol.icd.model.IcdIdentifier;

public class Icds {
    private final List<Icd> values;

    public static Icds of(Icd[] ... values) {
        return new Icds(values);
    }

    private Icds(Icd[] ... values) {
        this.values = Stream.of(values).map(Arrays::asList).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public IcdIdentifier parse(String s) throws PeppolParsingException {
        return this.parse(ParticipantIdentifier.parse(s));
    }

    public IcdIdentifier parse(ParticipantIdentifier participantIdentifier) throws PeppolParsingException {
        try {
            String[] parts = participantIdentifier.getIdentifier().split(":", 2);
            return IcdIdentifier.of(this.findBySchemeAndCode(participantIdentifier.getScheme(), parts[0]), parts[1]);
        }
        catch (IllegalArgumentException e) {
            throw new PeppolParsingException(e.getMessage(), e);
        }
    }

    public IcdIdentifier parse(String icd, String identifier) throws PeppolParsingException {
        try {
            return IcdIdentifier.of(this.findByIdentifier(icd), identifier);
        }
        catch (IllegalArgumentException e) {
            throw new PeppolParsingException(e.getMessage(), e);
        }
    }

    public Icd findBySchemeAndCode(Scheme scheme, String code) {
        return this.values.stream().filter(v -> v.getCode().equals(code) && v.getScheme().equals(scheme)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Value '%s::%s' is not valid ICD.", scheme, code)));
    }

    public Icd findByIdentifier(String identifier) {
        return this.values.stream().filter(v -> v.getIdentifier().equals(identifier)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Value '%s' is not valid ICD.", identifier)));
    }

    public Icd findByCode(String code) {
        return this.values.stream().filter(v -> v.getCode().equals(code)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Value '%s' is not valid ICD.", code)));
    }

    public List<Icd> values() {
        return Collections.unmodifiableList(this.values);
    }
}

