/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.security.xmldsig;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import network.oxalis.vefa.peppol.common.lang.PeppolRuntimeException;
import network.oxalis.vefa.peppol.common.util.ExceptionUtil;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmldsigSigner {
    private static TransformerFactory transformerFactory;
    private static XMLSignatureFactory xmlSignatureFactory;
    private String digestMethod;
    private String signatureMethod;

    public static XmldsigSigner SHA1() {
        return new XmldsigSigner("http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
    }

    public static XmldsigSigner SHA256() {
        return new XmldsigSigner("http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
    }

    XmldsigSigner(String digestMethod, String signatureMethod) {
        this.digestMethod = digestMethod;
        this.signatureMethod = signatureMethod;
    }

    public void sign(Document document, KeyStore.PrivateKeyEntry privateKeyEntry, Result result) throws PeppolSecurityException {
        this.sign(document.getDocumentElement(), privateKeyEntry, result);
    }

    public void sign(Element element, KeyStore.PrivateKeyEntry privateKeyEntry, Result result) throws PeppolSecurityException {
        try {
            Reference reference = xmlSignatureFactory.newReference("", xmlSignatureFactory.newDigestMethod(this.digestMethod, null), Collections.singletonList(xmlSignatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
            SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), xmlSignatureFactory.newSignatureMethod(this.signatureMethod, null), Collections.singletonList(reference));
            X509Certificate certificate = (X509Certificate)privateKeyEntry.getCertificate();
            ArrayList<Object> aX509Content = new ArrayList<Object>();
            aX509Content.add(certificate.getSubjectX500Principal().getName());
            aX509Content.add(certificate);
            KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
            X509Data x509Data = keyInfoFactory.newX509Data(aX509Content);
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
            XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo);
            DOMSignContext domSignContext = new DOMSignContext(privateKeyEntry.getPrivateKey(), (Node)element);
            signature.sign(domSignContext);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setParameter("indent", "no");
            transformer.transform(new DOMSource(element), result);
        }
        catch (Exception e) {
            throw new PeppolSecurityException(e.getMessage(), e);
        }
    }

    static {
        ExceptionUtil.perform(PeppolRuntimeException.class, () -> {
            transformerFactory = TransformerFactory.newInstance();
            xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM");
        });
    }
}

