/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class As2Disposition {
    public static Pattern pattern = Pattern.compile("(?i)(manual-action|automatic-action)\\s*/\\s*(MDN-sent-automatically|MDN-sent-manually)\\s*;\\s*(processed|failed)\\s*(/\\s*(error|warning|failure)\\s*:?\\s*(.*)){0,1}");
    ActionMode actionMode;
    SendingMode sendingMode;
    DispositionType dispositionType;
    DispositionModifier dispositionModifier;

    public As2Disposition(ActionMode actionMode, SendingMode sendingMode, DispositionType dispositionType) {
        this.actionMode = actionMode;
        this.sendingMode = sendingMode;
        this.dispositionType = dispositionType;
    }

    public As2Disposition(ActionMode actionMode, SendingMode sendingMode, DispositionType dispositionType, DispositionModifier dispositionModifier) {
        this.actionMode = actionMode;
        this.sendingMode = sendingMode;
        this.dispositionType = dispositionType;
        if (dispositionType == DispositionType.PROCESSED && dispositionModifier.prefix == DispositionModifier.Prefix.FAILURE) {
            throw new IllegalArgumentException("DispositionType 'processed' does not allow a prefix of 'failed'. Only 'error' and 'warning' are allowed");
        }
        this.dispositionModifier = dispositionModifier;
    }

    public static As2Disposition processed() {
        return new As2Disposition(ActionMode.AUTOMATIC, SendingMode.AUTOMATIC, DispositionType.PROCESSED);
    }

    public static As2Disposition processedWithWarning(String warningMessage) {
        return new As2Disposition(ActionMode.AUTOMATIC, SendingMode.AUTOMATIC, DispositionType.PROCESSED, DispositionModifier.warning(warningMessage));
    }

    public static As2Disposition processedWithError(String errorMessage) {
        return new As2Disposition(ActionMode.AUTOMATIC, SendingMode.AUTOMATIC, DispositionType.PROCESSED, DispositionModifier.error(errorMessage));
    }

    public static As2Disposition failed(String message) {
        return new As2Disposition(ActionMode.AUTOMATIC, SendingMode.AUTOMATIC, DispositionType.FAILED, DispositionModifier.failed(message));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.actionMode.getTextValue() + "/" + this.sendingMode.getTextValue() + "; " + this.dispositionType.getTextValue());
        if (this.dispositionModifier != null) {
            sb.append('/');
            sb.append(this.dispositionModifier.toString());
        }
        return sb.toString();
    }

    public static As2Disposition valueOf(String s) {
        As2Disposition result;
        String str = s == null ? "" : s.trim();
        Matcher matcher = pattern.matcher(str);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("'" + str + "' does not match pattern for As2Disposition");
        }
        String actionModeString = matcher.group(1);
        ActionMode actionMode = ActionMode.createFromTextValue(actionModeString);
        String sendingModeString = matcher.group(2);
        SendingMode sendingMode = SendingMode.createFromTextValue(sendingModeString);
        String dispositionTypeString = matcher.group(3);
        DispositionType dispositionType = DispositionType.valueOf(dispositionTypeString.toUpperCase());
        if (matcher.group(4) != null) {
            String dispositionModifierPrefixString = matcher.group(5);
            String dispositionModifierString = matcher.group(6);
            DispositionModifier dispositionModifier = new DispositionModifier(DispositionModifier.Prefix.valueOf(dispositionModifierPrefixString.toUpperCase()), dispositionModifierString);
            result = new As2Disposition(actionMode, sendingMode, dispositionType, dispositionModifier);
        } else {
            result = new As2Disposition(actionMode, sendingMode, dispositionType);
        }
        return result;
    }

    @Generated
    public ActionMode getActionMode() {
        return this.actionMode;
    }

    @Generated
    public SendingMode getSendingMode() {
        return this.sendingMode;
    }

    @Generated
    public DispositionType getDispositionType() {
        return this.dispositionType;
    }

    @Generated
    public DispositionModifier getDispositionModifier() {
        return this.dispositionModifier;
    }

    public static class DispositionModifier {
        private final Prefix prefix;
        private final String dispositionModifierExtension;

        DispositionModifier(Prefix prefix, String dispositionModifierExtension) {
            this.prefix = prefix;
            this.dispositionModifierExtension = dispositionModifierExtension;
        }

        public Prefix getPrefix() {
            return this.prefix;
        }

        public String getDispositionModifierExtension() {
            return this.dispositionModifierExtension;
        }

        public static DispositionModifier authenticationFailedError() {
            return new DispositionModifier(Prefix.ERROR, "authentication-failed");
        }

        public static DispositionModifier decompressionFailedError() {
            return new DispositionModifier(Prefix.ERROR, "decompression-failed");
        }

        public static DispositionModifier decryptionFailedError() {
            return new DispositionModifier(Prefix.ERROR, "decryption-failed");
        }

        public static DispositionModifier insufficientMessageSecurityError() {
            return new DispositionModifier(Prefix.ERROR, "insufficient-message-security");
        }

        public static DispositionModifier integrityCheckFailedError() {
            return new DispositionModifier(Prefix.ERROR, "integrity-check-failed");
        }

        public static DispositionModifier unexpectedProcessingError() {
            return new DispositionModifier(Prefix.ERROR, "unexpected-processing-error");
        }

        public static DispositionModifier warning(String description) {
            return new DispositionModifier(Prefix.WARNING, description);
        }

        public static DispositionModifier unsupportedFormatFailure() {
            return new DispositionModifier(Prefix.FAILURE, "unsupported format");
        }

        public static DispositionModifier unsupportedMicAlgorithms() {
            return new DispositionModifier(Prefix.FAILURE, "unsupported MIC-algorithms");
        }

        public static DispositionModifier failed(String description) {
            return new DispositionModifier(Prefix.FAILURE, description);
        }

        public static DispositionModifier error(String description) {
            return new DispositionModifier(Prefix.ERROR, description);
        }

        public String toString() {
            return String.valueOf((Object)this.prefix) + ": " + this.dispositionModifierExtension;
        }

        public static enum Prefix {
            ERROR,
            WARNING,
            FAILURE;

        }
    }

    public static enum DispositionType {
        PROCESSED("processed"),
        FAILED("failed");

        private final String textValue;

        private DispositionType(String textValue) {
            this.textValue = textValue;
        }

        public String getTextValue() {
            return this.textValue;
        }
    }

    public static enum SendingMode {
        MANUAL("MDN-sent-manually"),
        AUTOMATIC("MDN-sent-automatically");

        private final String textValue;

        private SendingMode(String textValue) {
            this.textValue = textValue;
        }

        public String getTextValue() {
            return this.textValue;
        }

        public static SendingMode createFromTextValue(String textValue) {
            for (SendingMode sendingMode : SendingMode.values()) {
                if (!sendingMode.getTextValue().equalsIgnoreCase(textValue)) continue;
                return sendingMode;
            }
            throw new IllegalArgumentException(textValue.toLowerCase() + " not recognised as a valid ActionMode");
        }
    }

    public static enum ActionMode {
        MANUAL("manual-action"),
        AUTOMATIC("automatic-action");

        private final String textValue;

        private ActionMode(String textValue) {
            this.textValue = textValue;
        }

        String getTextValue() {
            return this.textValue;
        }

        public static ActionMode createFromTextValue(String textValue) {
            for (ActionMode actionMode : ActionMode.values()) {
                if (!actionMode.getTextValue().equalsIgnoreCase(textValue)) continue;
                return actionMode;
            }
            throw new IllegalArgumentException(textValue.toLowerCase() + " not recognised as a valid ActionMode");
        }
    }
}

