/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.util;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributeType;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.InternalAttributeKeyImpl;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;

public final class OpenTelemetryUtils {
    private static final String SERVICE_NAME = "oxalis";
    public static final String SERVICE_NAME_ATTRIBUTE_KEY = "service.name";
    private static OpenTelemetry openTelemetry;

    private OpenTelemetryUtils() {
    }

    public static OpenTelemetry initOpenTelemetry(SpanProcessor spanProcessor) {
        if (openTelemetry == null) {
            Resource serviceNameResource = Resource.create((Attributes)Attributes.of((AttributeKey)InternalAttributeKeyImpl.create((String)SERVICE_NAME_ATTRIBUTE_KEY, (AttributeType)AttributeType.STRING), (Object)SERVICE_NAME));
            SdkTracerProvider tracerProvider = SdkTracerProvider.builder().addSpanProcessor(spanProcessor).setResource(Resource.getDefault().merge(serviceNameResource)).build();
            openTelemetry = OpenTelemetrySdk.builder().setTracerProvider(tracerProvider).buildAndRegisterGlobal();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> ((SdkTracerProvider)tracerProvider).close()));
        }
        return openTelemetry;
    }
}

