/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.util;

import com.sun.mail.util.LineOutputStream;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import network.oxalis.as2.code.Disposition;
import network.oxalis.as2.util.As2DateUtil;
import network.oxalis.commons.util.OxalisVersion;

public class MdnBuilder {
    private static final String ISSUER = String.format("Oxalis %s", OxalisVersion.getVersion());
    private InternetHeaders headers = new InternetHeaders();
    private ByteArrayOutputStream textOutputStream = new ByteArrayOutputStream();
    private LineOutputStream textLineOutputStream = new LineOutputStream(this.textOutputStream);

    public static MdnBuilder newInstance(MimeMessage mimeMessage) throws MessagingException, IOException {
        MdnBuilder mdnBuilder = new MdnBuilder();
        mdnBuilder.addHeader("Reporting-UA", ISSUER);
        String recipient = String.format("rfc822; %s", mimeMessage.getHeader("AS2-To")[0]);
        mdnBuilder.addHeader("Original-Recipient", recipient);
        mdnBuilder.addHeader("Final-Recipient", recipient);
        mdnBuilder.textLineOutputStream.writeln("= Received headers");
        mdnBuilder.textLineOutputStream.writeln();
        for (String header : Collections.list(mimeMessage.getAllHeaderLines())) {
            mdnBuilder.textLineOutputStream.writeln(header);
        }
        mdnBuilder.textLineOutputStream.writeln();
        return mdnBuilder;
    }

    private MdnBuilder() {
    }

    public void addText(String title, String text) throws IOException {
        this.textLineOutputStream.writeln(String.format("= %s", title));
        this.textLineOutputStream.writeln();
        this.textLineOutputStream.writeln(String.valueOf(text));
        this.textLineOutputStream.writeln();
    }

    public void addHeader(String name, String value) {
        this.headers.addHeader(name, value);
    }

    public void addHeader(String name, Date value) {
        this.headers.addHeader(name, As2DateUtil.RFC822.format(value));
    }

    public void addHeader(String name, byte[] value) {
        this.headers.addHeader(name, Base64.getEncoder().encodeToString(value));
    }

    public void addHeader(String name, Object value) {
        this.headers.addHeader(name, value.toString());
    }

    public void addHeader(String name, Disposition disposition) {
        this.headers.addHeader(name, disposition.toString());
    }

    public MimeBodyPart build() throws MessagingException, IOException {
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMultipart.setSubType("report; Report-Type=disposition-notification");
        MimeBodyPart textPart = new MimeBodyPart();
        this.textLineOutputStream.close();
        textPart.setContent(this.textOutputStream.toString("UTF-8"), "text/plain");
        mimeMultipart.addBodyPart(textPart);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
        for (String header : Collections.list(this.headers.getAllHeaderLines())) {
            lineOutputStream.writeln(header);
        }
        lineOutputStream.close();
        MimeBodyPart headerPart = new MimeBodyPart();
        headerPart.setContent(outputStream.toString(), "message/disposition-notification");
        mimeMultipart.addBodyPart(headerPart);
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent(mimeMultipart, mimeMultipart.getContentType());
        return mimeBodyPart;
    }
}

