/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.config;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import lombok.Generated;
import network.oxalis.commons.config.JavaPropertiesPostConfig;
import network.oxalis.commons.config.PostConfig;
import network.oxalis.commons.guice.OxalisModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigModule
extends OxalisModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigModule.class);

    @Override
    protected void configure() {
        Multibinder<PostConfig> multibinder = Multibinder.newSetBinder(this.binder(), PostConfig.class);
        multibinder.addBinding().to(JavaPropertiesPostConfig.class);
    }

    @Provides
    @Singleton
    @Named(value="file")
    protected Config loadConfigurationFile(@Named(value="conf") Path homePath) {
        Path configPath = homePath.resolve("oxalis.conf");
        log.info("Configuration file: {}", (Object)configPath);
        return Files.exists(configPath, new LinkOption[0]) && Files.isReadable(configPath) ? ConfigFactory.parseFile(configPath.toFile()).resolve() : ConfigFactory.empty();
    }

    @Provides
    @Singleton
    @Named(value="reference")
    protected Config loadConfigurationReference() {
        Config referenceConfig = ConfigFactory.defaultReference();
        return referenceConfig.withFallback(referenceConfig.getConfig("defaults"));
    }

    @Provides
    @Singleton
    protected Config loadConfiguration(@Named(value="file") Config config, @Named(value="reference") Config referenceConfig, Set<PostConfig> postConfigs) {
        Config result = ConfigFactory.systemProperties().withFallback(config).withFallback(referenceConfig);
        postConfigs.forEach(pc -> pc.perform(result));
        return result;
    }
}

