/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.transformer;

import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import network.oxalis.api.settings.Settings;
import network.oxalis.api.transformer.ContentDetector;
import network.oxalis.api.transformer.ContentWrapper;
import network.oxalis.commons.guice.ImplLoader;
import network.oxalis.commons.guice.OxalisModule;
import network.oxalis.commons.transformer.NoopContentDetector;
import network.oxalis.commons.transformer.NoopContentWrapper;
import network.oxalis.commons.transformer.TransformerConf;

public class TransformerModule
extends OxalisModule {
    @Override
    protected void configure() {
        this.bindTyped(ContentDetector.class, NoopContentDetector.class);
        this.bindTyped(ContentWrapper.class, NoopContentWrapper.class);
        this.bindSettings(TransformerConf.class);
    }

    @Provides
    @Singleton
    protected ContentDetector getContentDetector(Injector injector, Settings<TransformerConf> settings) {
        return ImplLoader.get(injector, ContentDetector.class, settings, TransformerConf.DETECTOR);
    }

    @Provides
    @Singleton
    protected ContentWrapper getContentWrapper(Injector injector, Settings<TransformerConf> settings) {
        return ImplLoader.get(injector, ContentWrapper.class, settings, TransformerConf.WRAPPER);
    }
}

