/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.outbound.lookup;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import network.oxalis.api.lookup.LookupService;
import network.oxalis.commons.guice.OxalisModule;
import network.oxalis.commons.mode.OxalisCertificateValidator;
import network.oxalis.outbound.lookup.CachedLookupService;
import network.oxalis.outbound.lookup.DefaultLookupService;
import network.oxalis.outbound.lookup.OxalisApacheFetcher;
import network.oxalis.vefa.peppol.common.lang.PeppolLoadingException;
import network.oxalis.vefa.peppol.lookup.LookupClient;
import network.oxalis.vefa.peppol.lookup.LookupClientBuilder;
import network.oxalis.vefa.peppol.lookup.api.MetadataFetcher;
import network.oxalis.vefa.peppol.mode.Mode;

public class LookupModule
extends OxalisModule {
    @Override
    protected void configure() {
        this.bindTyped(LookupService.class, CachedLookupService.class);
        this.bindTyped(LookupService.class, DefaultLookupService.class);
        this.bind(MetadataFetcher.class).to(OxalisApacheFetcher.class);
    }

    @Provides
    @Singleton
    protected LookupService getLookupService(Mode mode, Injector injector) {
        return injector.getInstance(Key.get(LookupService.class, (Annotation)Names.named(mode.getString("oxalis.lookup.service"))));
    }

    @Provides
    @Singleton
    protected LookupClient providesLookupClient(Mode mode, OxalisCertificateValidator certificateValidator, MetadataFetcher fetcher) throws PeppolLoadingException {
        return LookupClientBuilder.forMode(mode).fetcher(fetcher).certificateValidator(certificateValidator).build();
    }
}

