/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.statistics.inbound;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Date;
import java.util.Map;
import network.oxalis.statistics.api.StatisticsGranularity;
import network.oxalis.statistics.inbound.StatisticsProducer;
import network.oxalis.statistics.security.OxalisCipher;
import network.oxalis.statistics.security.OxalisCipherConverter;
import network.oxalis.statistics.security.StatisticsKeyTool;
import org.joda.time.DateTime;

@Singleton
public class StatisticsServlet
extends HttpServlet {
    @Inject
    private StatisticsProducer statisticsProducer;
    private PublicKey publicKey;
    @Inject
    private StatisticsKeyTool statisticsKeyTool;

    public void init(ServletConfig servletConfig) {
        this.publicKey = this.statisticsKeyTool.loadPublicKeyFromClassPath();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.getOutputStream().write("Hello!\nOxalis statistics does not support http POST".getBytes());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map parameterMap = request.getParameterMap();
        Params params = this.parseParams(parameterMap);
        ServletOutputStream servletOutputStream = response.getOutputStream();
        OxalisCipher oxalisCipher = new OxalisCipher();
        String wrappedSymmetricKeyAsString = new OxalisCipherConverter().getWrappedSymmetricKeyAsString(this.publicKey, oxalisCipher);
        response.setHeader("PEPPOL-wrapped-key", wrappedSymmetricKeyAsString);
        OutputStream encryptedOutputStream = oxalisCipher.encryptStream((OutputStream)servletOutputStream);
        this.statisticsProducer.emitData(encryptedOutputStream, params.start, params.end, params.granularity);
        encryptedOutputStream.close();
    }

    Params parseParams(Map<String, String[]> parameterMap) {
        Params result = new Params();
        this.parseGranularity(parameterMap, result);
        this.parseDates(parameterMap, result);
        return result;
    }

    private void parseDates(Map<String, String[]> parameterMap, Params result) {
        result.start = this.parseDate(this.getParamFromMultiValues(parameterMap, "start"));
        result.end = this.parseDate(this.getParamFromMultiValues(parameterMap, "end"));
    }

    private void parseGranularity(Map<String, String[]> parameterMap, Params result) {
        String granularity = this.getParamFromMultiValues(parameterMap, "g");
        if (granularity == null) {
            granularity = this.getParamFromMultiValues(parameterMap, "granularity");
        }
        if (granularity == null) {
            throw new IllegalArgumentException("Missing request parameter: 'granularity' (Y,M,D or H)");
        }
        result.granularity = StatisticsGranularity.valueForAbbreviation(granularity);
    }

    String getParamFromMultiValues(Map<String, String[]> parameterMap, String key) {
        String[] values = parameterMap.get(key);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    private Date parseDate(String dateAsString) {
        if (dateAsString != null) {
            try {
                DateTime date = DateTime.parse((String)dateAsString);
                return date.toDate();
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Unable to parseMultipart '%s'into a date and time using ISO8601 pattern YYYY-MM-DD HH", dateAsString));
            }
        }
        return null;
    }

    static class Params {
        Date start;
        Date end;
        StatisticsGranularity granularity;

        Params() {
        }
    }
}

