/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.inbound;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletModule;
import java.lang.annotation.Annotation;
import network.oxalis.api.inbound.InboundService;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.guice.ImplLoader;
import network.oxalis.commons.settings.SettingsBuilder;
import network.oxalis.inbound.DefaultInboundService;
import network.oxalis.inbound.servlet.HomeServlet;
import network.oxalis.inbound.servlet.StatusServlet;
import network.oxalis.inbound.tracing.DefaultOpenTelemetryTracingFilter;
import network.oxalis.inbound.tracing.OpenTelemetryServletConf;
import network.oxalis.inbound.tracing.OpenTelemetryTracingFilter;

public class InboundModule
extends ServletModule {
    protected void configureServlets() {
        SettingsBuilder.with((Binder)this.binder(), OpenTelemetryServletConf.class);
        this.filter("/*", new String[0]).through(OpenTelemetryTracingFilter.class);
        this.serve("/", new String[0]).with(HomeServlet.class);
        this.serve("/status", new String[0]).with(StatusServlet.class);
        this.bind(InboundService.class).to(DefaultInboundService.class);
        this.bind(Key.get(OpenTelemetryTracingFilter.class, (Annotation)Names.named((String)"default"))).to(DefaultOpenTelemetryTracingFilter.class);
    }

    @Provides
    @Singleton
    protected OpenTelemetryTracingFilter getOpenTelemetryTracingFilter(Injector injector, Settings<OpenTelemetryServletConf> settings) {
        return (OpenTelemetryTracingFilter)ImplLoader.get((Injector)injector, OpenTelemetryTracingFilter.class, settings, (Object)((Object)OpenTelemetryServletConf.TRACING_FILTER));
    }
}

