/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CacheSizeExceededException;
import org.apache.cxf.io.CachedOutputStream;

public class CompressionUtil {
    public InputStream getCompressedStream(InputStream sourceStream) throws IOException {
        InputStream inputStream;
        if (sourceStream == null) {
            throw new IllegalArgumentException("Source Stream cannot be NULL");
        }
        CachedOutputStream cache = new CachedOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream((OutputStream)cache);
        try {
            IOUtils.copyAndCloseInput((InputStream)sourceStream, (OutputStream)gzipOutputStream);
            gzipOutputStream.flush();
            gzipOutputStream.finish();
            inputStream = cache.getInputStream();
        }
        catch (Throwable throwable) {
            try {
                try {
                    gzipOutputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CacheSizeExceededException cee) {
                sourceStream.close();
                throw cee;
            }
        }
        gzipOutputStream.close();
        return inputStream;
    }
}

