/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.util;

public enum AS4ErrorCode {
    EBMS_0001("EBMS:0001", "ValueNotRecognized", Category.CONTENT, Origin.EBMS),
    EBMS_0002("EBMS:0002", "FeatureNotSupported", Category.CONTENT, Origin.EBMS),
    EBMS_0003("EBMS:0003", "ValueInconsistent", Category.CONTENT, Origin.EBMS),
    EBMS_0004("EBMS:0004", "Other", Category.CONTENT, Origin.EBMS),
    EBMS_0005("EBMS:0005", "ConnectionFailure", Category.COMMUNICATION, Origin.EBMS),
    EBMS_0006("EBMS:0006", "EmptyMessagePartitionFlow", Category.COMMUNICATION, Origin.EBMS),
    EBMS_0007("EBMS:0007", "MimeInconsistency", Category.UNPACKAGING, Origin.EBMS),
    EBMS_0008("EBMS:0008", "FeatureNotSupported", Category.UNPACKAGING, Origin.EBMS),
    EBMS_0009("EBMS:0009", "InvalidHeader", Category.UNPACKAGING, Origin.EBMS),
    EBMS_0010("EBMS:0010", "ProcessingModeMismatch", Category.PROCESSING, Origin.EBMS),
    EBMS_0101("EBMS:0101", "FailedAuthentication", Category.PROCESSING, Origin.SECURITY),
    EBMS_0102("EBMS:0102", "FailedDecryption", Category.PROCESSING, Origin.SECURITY),
    EBMS_0103("EBMS:0103", "PolicyNoncompliance", Category.PROCESSING, Origin.SECURITY),
    EBMS_0201("EBMS:0201", "DysfunctionalReliability", Category.PROCESSING, Origin.SECURITY),
    EBMS_0202("EBMS:0202", "DeliveryFailure", Category.COMMUNICATION, Origin.SECURITY),
    EBMS_0301("EBMS:0301", "MissingReceipt", Category.COMMUNICATION, Origin.EBMS),
    EBMS_0303("EBMS:0303", "DecompressionFailure", Category.COMMUNICATION, Origin.EBMS);

    private String errorCode;
    private String shortDescription;
    private Category catgory;
    private Origin origin;

    private AS4ErrorCode(String errorCode, String shortDescription, Category category, Origin origin) {
        this.errorCode = errorCode;
        this.shortDescription = shortDescription;
        this.catgory = category;
        this.origin = origin;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public Category getCatgory() {
        return this.catgory;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public static AS4ErrorCode nameOf(String name) {
        for (AS4ErrorCode errorCode : AS4ErrorCode.values()) {
            if (!errorCode.toString().equalsIgnoreCase(name)) continue;
            return errorCode;
        }
        return null;
    }

    public String toString() {
        return this.getErrorCode();
    }

    public static enum Severity {
        ERROR,
        FAILURE,
        WARNING;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static Severity nameOf(String name) {
            for (Severity severity : Severity.values()) {
                if (!severity.toString().equalsIgnoreCase(name)) continue;
                return severity;
            }
            return null;
        }
    }

    public static enum Origin {
        EBMS,
        SECURITY,
        RELIABILITY;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Category {
        CONTENT,
        COMMUNICATION,
        UNPACKAGING,
        PROCESSING;


        public String toString() {
            return this.name().substring(0, 1).toUpperCase() + this.name().substring(1).toLowerCase();
        }
    }
}

