/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.plugin;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import network.oxalis.ng.api.lang.OxalisPluginException;
import network.oxalis.ng.api.plugin.PluginFactory;
import network.oxalis.ng.commons.guice.GuiceServiceLoader;

class PluginFactoryImpl
implements PluginFactory {
    private final GuiceServiceLoader guiceServiceLoader;
    private final ClassLoader classLoader;

    @Inject
    public PluginFactoryImpl(GuiceServiceLoader guiceServiceLoader, @Named(value="plugin") ClassLoader classLoader) {
        this.guiceServiceLoader = guiceServiceLoader;
        this.classLoader = classLoader;
    }

    public <T> T newInstance(Class<T> cls) {
        List<T> instances = this.guiceServiceLoader.load(cls, this.classLoader);
        if (instances.size() != 1) {
            throw new OxalisPluginException(String.format("Found %s implementations of '%s'.", instances.size(), cls.getCanonicalName()));
        }
        return instances.get(0);
    }
}

