/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.AttributeUtil;
import io.opentelemetry.sdk.internal.AttributesMap;
import io.opentelemetry.sdk.internal.InstrumentationScopeUtil;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.AnchoredClock;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.SpanWrapper;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.sdk.trace.internal.ExtendedSpanProcessor;
import io.opentelemetry.sdk.trace.internal.data.ExceptionEventData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SdkSpan
implements ReadWriteSpan {
    private static final Logger logger = Logger.getLogger(SdkSpan.class.getName());
    private final SpanLimits spanLimits;
    private final SpanContext context;
    private final SpanContext parentSpanContext;
    private final SpanProcessor spanProcessor;
    private final SpanKind kind;
    private final AnchoredClock clock;
    private final Resource resource;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private final long startEpochNanos;
    private final Object lock = new Object();
    private String name;
    @Nullable
    private AttributesMap attributes;
    @Nullable
    private List<EventData> events;
    private int totalRecordedEvents = 0;
    @Nullable
    List<LinkData> links;
    private int totalRecordedLinks;
    private StatusData status = StatusData.unset();
    private long endEpochNanos;
    private EndState hasEnded;
    @Nullable
    private Thread spanEndingThread;

    private SdkSpan(SpanContext context, String name, InstrumentationScopeInfo instrumentationScopeInfo, SpanKind kind, SpanContext parentSpanContext, SpanLimits spanLimits, SpanProcessor spanProcessor, AnchoredClock clock, Resource resource, @Nullable AttributesMap attributes, @Nullable List<LinkData> links, int totalRecordedLinks, long startEpochNanos) {
        this.context = context;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.parentSpanContext = parentSpanContext;
        this.links = links;
        this.totalRecordedLinks = totalRecordedLinks;
        this.name = name;
        this.kind = kind;
        this.spanProcessor = spanProcessor;
        this.resource = resource;
        this.hasEnded = EndState.NOT_ENDED;
        this.clock = clock;
        this.startEpochNanos = startEpochNanos;
        this.attributes = attributes;
        this.spanLimits = spanLimits;
    }

    static SdkSpan startSpan(SpanContext context, String name, InstrumentationScopeInfo instrumentationScopeInfo, SpanKind kind, Span parentSpan, Context parentContext, SpanLimits spanLimits, SpanProcessor spanProcessor, Clock tracerClock, Resource resource, @Nullable AttributesMap attributes, @Nullable List<LinkData> links, int totalRecordedLinks, long userStartEpochNanos) {
        boolean createdAnchoredClock;
        AnchoredClock clock;
        if (parentSpan instanceof SdkSpan) {
            SdkSpan parentRecordEventsSpan = (SdkSpan)parentSpan;
            clock = parentRecordEventsSpan.clock;
            createdAnchoredClock = false;
        } else {
            clock = AnchoredClock.create(tracerClock);
            createdAnchoredClock = true;
        }
        long startEpochNanos = userStartEpochNanos != 0L ? userStartEpochNanos : (createdAnchoredClock ? clock.startTime() : clock.now());
        SdkSpan span = new SdkSpan(context, name, instrumentationScopeInfo, kind, parentSpan.getSpanContext(), spanLimits, spanProcessor, clock, resource, attributes, links, totalRecordedLinks, startEpochNanos);
        if (spanProcessor.isStartRequired()) {
            spanProcessor.onStart(parentContext, span);
        }
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpanData toSpanData() {
        Object object = this.lock;
        synchronized (object) {
            return SpanWrapper.create(this, this.getImmutableLinks(), this.getImmutableTimedEvents(), this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues(), this.totalRecordedEvents, this.totalRecordedLinks, this.status, this.name, this.endEpochNanos, this.hasEnded == EndState.ENDED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <T> T getAttribute(AttributeKey<T> key) {
        Object object = this.lock;
        synchronized (object) {
            return this.attributes == null ? null : (T)this.attributes.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Attributes getAttributes() {
        Object object = this.lock;
        synchronized (object) {
            return this.attributes == null ? Attributes.empty() : this.attributes.immutableCopy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEnded() {
        Object object = this.lock;
        synchronized (object) {
            return this.hasEnded == EndState.ENDED;
        }
    }

    @Override
    public SpanContext getSpanContext() {
        return this.context;
    }

    @Override
    public SpanContext getParentSpanContext() {
        return this.parentSpanContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    @Override
    @Deprecated
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return InstrumentationScopeUtil.toInstrumentationLibraryInfo(this.getInstrumentationScopeInfo());
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return this.instrumentationScopeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyNanos() {
        Object object = this.lock;
        synchronized (object) {
            return (this.hasEnded == EndState.NOT_ENDED ? this.clock.now() : this.endEpochNanos) - this.startEpochNanos;
        }
    }

    AnchoredClock getClock() {
        return this.clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ReadWriteSpan setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isModifiableByCurrentThread()) {
                logger.log(Level.FINE, "Calling setAttribute() on an ended Span.");
                return this;
            }
            if (this.attributes == null) {
                this.attributes = AttributesMap.create(this.spanLimits.getMaxNumberOfAttributes(), this.spanLimits.getMaxAttributeValueLength());
            }
            this.attributes.put(key, value);
        }
        return this;
    }

    private boolean isModifiableByCurrentThread() {
        return this.hasEnded == EndState.NOT_ENDED || this.hasEnded == EndState.ENDING && Thread.currentThread() == this.spanEndingThread;
    }

    @Override
    public ReadWriteSpan addEvent(String name) {
        if (name == null) {
            return this;
        }
        this.addTimedEvent(EventData.create(this.clock.now(), name, Attributes.empty(), 0));
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String name, long timestamp, TimeUnit unit) {
        if (name == null || unit == null) {
            return this;
        }
        this.addTimedEvent(EventData.create(unit.toNanos(timestamp), name, Attributes.empty(), 0));
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String name, Attributes attributes) {
        if (name == null) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int totalAttributeCount = attributes.size();
        this.addTimedEvent(EventData.create(this.clock.now(), name, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerEvent(), this.spanLimits.getMaxAttributeValueLength()), totalAttributeCount));
        return this;
    }

    @Override
    public ReadWriteSpan addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
        if (name == null || unit == null) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int totalAttributeCount = attributes.size();
        this.addTimedEvent(EventData.create(unit.toNanos(timestamp), name, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerEvent(), this.spanLimits.getMaxAttributeValueLength()), totalAttributeCount));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimedEvent(EventData timedEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isModifiableByCurrentThread()) {
                logger.log(Level.FINE, "Calling addEvent() on an ended Span.");
                return;
            }
            if (this.events == null) {
                this.events = new ArrayList<EventData>();
            }
            if (this.events.size() < this.spanLimits.getMaxNumberOfEvents()) {
                this.events.add(timedEvent);
            }
            ++this.totalRecordedEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadWriteSpan setStatus(StatusCode statusCode, @Nullable String description) {
        if (statusCode == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isModifiableByCurrentThread()) {
                logger.log(Level.FINE, "Calling setStatus() on an ended Span.");
                return this;
            }
            if (this.status.getStatusCode() == StatusCode.OK) {
                logger.log(Level.FINE, "Calling setStatus() on a Span that is already set to OK.");
                return this;
            }
            this.status = StatusData.create(statusCode, description);
        }
        return this;
    }

    @Override
    public ReadWriteSpan recordException(Throwable exception) {
        this.recordException(exception, Attributes.empty());
        return this;
    }

    @Override
    public ReadWriteSpan recordException(Throwable exception, Attributes additionalAttributes) {
        if (exception == null) {
            return this;
        }
        if (additionalAttributes == null) {
            additionalAttributes = Attributes.empty();
        }
        this.addTimedEvent(ExceptionEventData.create(this.spanLimits, this.clock.now(), exception, additionalAttributes));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadWriteSpan updateName(String name) {
        if (name == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isModifiableByCurrentThread()) {
                logger.log(Level.FINE, "Calling updateName() on an ended Span.");
                return this;
            }
            this.name = name;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span addLink(SpanContext spanContext, Attributes attributes) {
        if (spanContext == null || !spanContext.isValid()) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        LinkData link = LinkData.create(spanContext, AttributeUtil.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerLink(), this.spanLimits.getMaxAttributeValueLength()));
        Object object = this.lock;
        synchronized (object) {
            if (!this.isModifiableByCurrentThread()) {
                logger.log(Level.FINE, "Calling addLink() on an ended Span.");
                return this;
            }
            if (this.links == null) {
                this.links = new ArrayList<LinkData>();
            }
            if (this.links.size() < this.spanLimits.getMaxNumberOfLinks()) {
                this.links.add(link);
            }
            ++this.totalRecordedLinks;
        }
        return this;
    }

    @Override
    public void end() {
        this.endInternal(this.clock.now());
    }

    @Override
    public void end(long timestamp, TimeUnit unit) {
        if (unit == null) {
            unit = TimeUnit.NANOSECONDS;
        }
        this.endInternal(timestamp == 0L ? this.clock.now() : unit.toNanos(timestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endInternal(long endEpochNanos) {
        ExtendedSpanProcessor extendedSpanProcessor;
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded != EndState.NOT_ENDED) {
                logger.log(Level.FINE, "Calling end() on an ended or ending Span.");
                return;
            }
            this.endEpochNanos = endEpochNanos;
            this.spanEndingThread = Thread.currentThread();
            this.hasEnded = EndState.ENDING;
        }
        if (this.spanProcessor instanceof ExtendedSpanProcessor && (extendedSpanProcessor = (ExtendedSpanProcessor)this.spanProcessor).isOnEndingRequired()) {
            extendedSpanProcessor.onEnding(this);
        }
        object = this.lock;
        synchronized (object) {
            this.hasEnded = EndState.ENDED;
        }
        if (this.spanProcessor.isEndRequired()) {
            this.spanProcessor.onEnd(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRecording() {
        Object object = this.lock;
        synchronized (object) {
            return this.hasEnded != EndState.ENDED;
        }
    }

    Resource getResource() {
        return this.resource;
    }

    @Override
    public SpanKind getKind() {
        return this.kind;
    }

    long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    private List<EventData> getImmutableTimedEvents() {
        if (this.events == null) {
            return Collections.emptyList();
        }
        if (this.hasEnded == EndState.ENDED) {
            return Collections.unmodifiableList(this.events);
        }
        return Collections.unmodifiableList(new ArrayList<EventData>(this.events));
    }

    private Attributes getImmutableAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return Attributes.empty();
        }
        if (this.hasEnded == EndState.ENDED) {
            return this.attributes;
        }
        return this.attributes.immutableCopy();
    }

    private List<LinkData> getImmutableLinks() {
        if (this.links == null || this.links.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.links);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long totalRecordedLinks;
        long endEpochNanos;
        long totalRecordedEvents;
        String status;
        String attributes;
        String name;
        Object object = this.lock;
        synchronized (object) {
            name = this.name;
            attributes = String.valueOf(this.attributes);
            status = String.valueOf(this.status);
            totalRecordedEvents = this.totalRecordedEvents;
            endEpochNanos = this.endEpochNanos;
            totalRecordedLinks = this.totalRecordedLinks;
        }
        return "SdkSpan{traceId=" + this.context.getTraceId() + ", spanId=" + this.context.getSpanId() + ", parentSpanContext=" + this.parentSpanContext + ", name=" + name + ", kind=" + (Object)((Object)this.kind) + ", attributes=" + attributes + ", status=" + status + ", totalRecordedEvents=" + totalRecordedEvents + ", totalRecordedLinks=" + totalRecordedLinks + ", startEpochNanos=" + this.startEpochNanos + ", endEpochNanos=" + endEpochNanos + "}";
    }

    private static enum EndState {
        NOT_ENDED,
        ENDING,
        ENDED;

    }
}

