/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.locator;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SimpleResolver;

public class CustomExtendedDNSResolver {
    private CustomExtendedDNSResolver() {
    }

    public static void setCustomizeResolverTimeout(Resolver resolver2, long timeout) {
        resolver2.setTimeout(Duration.ofSeconds(timeout));
    }

    public static void setCustomizeResolverTimeoutAndMaxRetries(ExtendedResolver extendedResolver, long timeout, int maxRetries) {
        CustomExtendedDNSResolver.setCustomizeResolverTimeout(extendedResolver, timeout);
        extendedResolver.setRetries(maxRetries);
    }

    public static void iterateEachDefaultResolverAndConfigure(Consumer<? super SimpleResolver> consumer, long timeout) {
        for (InetSocketAddress inetSocketAddress : ResolverConfig.getCurrentConfig().servers()) {
            if (inetSocketAddress == null) continue;
            SimpleResolver simpleResolver = new SimpleResolver(inetSocketAddress);
            CustomExtendedDNSResolver.setCustomizeResolverTimeout(simpleResolver, timeout);
            consumer.accept(simpleResolver);
        }
    }

    public static void iterateEachResolverAndConfigure(Iterable<? extends InetAddress> customDNSServersAddress, Consumer<? super SimpleResolver> aConsumer, long timeout) {
        if (customDNSServersAddress != null) {
            for (InetAddress inetAddress : customDNSServersAddress) {
                if (inetAddress == null) continue;
                SimpleResolver simpleResolver = new SimpleResolver(inetAddress);
                CustomExtendedDNSResolver.setCustomizeResolverTimeout(simpleResolver, timeout);
                aConsumer.accept(simpleResolver);
            }
        }
    }

    private static boolean isResolverAlreadyAvailable(List<Resolver> resolverList, SimpleResolver simpleResolver) {
        InetSocketAddress aSearchAddr = simpleResolver.getAddress();
        return resolverList.stream().filter(x -> x instanceof SimpleResolver).map(x -> (SimpleResolver)x).anyMatch(x -> x.getAddress().equals(aSearchAddr));
    }

    public static ExtendedResolver createExtendedResolver(Iterable<? extends InetAddress> customDNSServersAddress, long timeout, int maxRetries) {
        ArrayList<Resolver> resolverList = new ArrayList<Resolver>();
        CustomExtendedDNSResolver.iterateEachResolverAndConfigure(customDNSServersAddress, x -> {
            if (!CustomExtendedDNSResolver.isResolverAlreadyAvailable(resolverList, x)) {
                resolverList.add((Resolver)x);
            }
        }, timeout);
        CustomExtendedDNSResolver.iterateEachDefaultResolverAndConfigure(x -> {
            if (!CustomExtendedDNSResolver.isResolverAlreadyAvailable(resolverList, x)) {
                resolverList.add((Resolver)x);
            }
        }, timeout);
        ExtendedResolver extendedResolver = new ExtendedResolver(resolverList);
        CustomExtendedDNSResolver.setCustomizeResolverTimeoutAndMaxRetries(extendedResolver, timeout, maxRetries);
        return extendedResolver;
    }
}

