/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.event;

import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.security.auth.Subject;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.ext.logging.MaskSensitiveHelper;
import org.apache.cxf.ext.logging.event.EventType;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.ContextUtils;

public class DefaultLogEventMapper {
    public static final String MASKED_HEADER_VALUE = "XXX";
    private static final Set<String> DEFAULT_BINARY_CONTENT_MEDIA_TYPES;
    private static final String MULTIPART_CONTENT_MEDIA_TYPE = "multipart";
    private final Set<String> binaryContentMediaTypes = new HashSet<String>(DEFAULT_BINARY_CONTENT_MEDIA_TYPES);
    private MaskSensitiveHelper maskSensitiveHelper = new MaskSensitiveHelper();

    public void addBinaryContentMediaTypes(String mediaTypes) {
        if (mediaTypes != null) {
            Collections.addAll(this.binaryContentMediaTypes, mediaTypes.split(";"));
        }
    }

    public LogEvent map(Message message) {
        return this.map(message, Collections.emptySet());
    }

    public LogEvent map(Message message, Set<String> sensitiveProtocolHeaders) {
        Integer responseCode;
        LogEvent event = new LogEvent();
        event.setMessageId(this.getMessageId(message));
        event.setExchangeId((String)message.getExchange().get("exchangeId"));
        event.setType(this.getEventType(message));
        if (!Boolean.TRUE.equals(message.get("decoupled.channel.message")) && (responseCode = (Integer)message.get(Message.RESPONSE_CODE)) != null) {
            event.setResponseCode(responseCode.toString());
        }
        event.setEncoding(DefaultLogEventMapper.safeGet(message, Message.ENCODING));
        event.setHttpMethod(DefaultLogEventMapper.safeGet(message, "org.apache.cxf.request.method"));
        event.setContentType(DefaultLogEventMapper.safeGet(message, "Content-Type"));
        Map<String, String> headerMap = this.getHeaders(message);
        if (sensitiveProtocolHeaders != null && !sensitiveProtocolHeaders.isEmpty()) {
            this.maskSensitiveHelper.maskHeaders(headerMap, sensitiveProtocolHeaders);
        }
        event.setHeaders(headerMap);
        event.setAddress(this.getAddress(message, event));
        event.setPrincipal(this.getPrincipal(message));
        event.setBinaryContent(this.isBinaryContent(message));
        event.setMultipartContent(this.isMultipartContent(message));
        this.setEpInfo(message, event);
        return event;
    }

    private String getPrincipal(Message message) {
        String principal = this.getJAASPrincipal();
        if (principal != null) {
            return principal;
        }
        SecurityContext sc = message.get(SecurityContext.class);
        if (sc != null && sc.getUserPrincipal() != null) {
            return sc.getUserPrincipal().getName();
        }
        AuthorizationPolicy authPolicy = message.get(AuthorizationPolicy.class);
        if (authPolicy != null) {
            return authPolicy.getUserName();
        }
        return null;
    }

    private String getJAASPrincipal() {
        StringBuilder principals = new StringBuilder();
        Iterator<? extends Object> principalIt = this.getJAASPrincipals();
        while (principalIt.hasNext()) {
            principals.append(principalIt.next());
            if (!principalIt.hasNext()) continue;
            principals.append(',');
        }
        if (principals.length() == 0) {
            return null;
        }
        return principals.toString();
    }

    private Iterator<? extends Object> getJAASPrincipals() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        return subject != null && subject.getPrincipals() != null ? subject.getPrincipals().iterator() : Collections.emptyIterator();
    }

    private Map<String, String> getHeaders(Message message) {
        Map headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        HashMap<String, String> result = new HashMap<String, String>();
        if (headers == null) {
            return result;
        }
        for (Map.Entry entry : headers.entrySet()) {
            List list;
            List list2 = list = entry.getValue() != null ? (List)entry.getValue() : Collections.emptyList();
            if (list.size() == 1) {
                Object value = list.get(0);
                if (value == null) continue;
                result.put((String)entry.getKey(), value.toString());
                continue;
            }
            result.put((String)entry.getKey(), Arrays.deepToString(list.toArray()));
        }
        return result;
    }

    private String getAddress(Message message, LogEvent event) {
        Message observedMessage = event.getType() == EventType.RESP_IN ? message.getExchange().getOutMessage() : (event.getType() == EventType.RESP_OUT ? message.getExchange().getInMessage() : message);
        return this.getUri(observedMessage);
    }

    private String getUri(Message message) {
        String query;
        Object uri = DefaultLogEventMapper.safeGet(message, "org.apache.cxf.request.url");
        if (uri == null) {
            String address = DefaultLogEventMapper.safeGet(message, Message.ENDPOINT_ADDRESS);
            uri = DefaultLogEventMapper.safeGet(message, "org.apache.cxf.request.uri");
            if (uri != null && ((String)uri).startsWith("/")) {
                if (address != null && !address.startsWith((String)uri)) {
                    if (address.endsWith("/") && address.length() > 1) {
                        address = address.substring(0, address.length() - 1);
                    }
                    uri = address + (String)uri;
                }
            } else if (address != null) {
                uri = address;
            }
        }
        if ((query = DefaultLogEventMapper.safeGet(message, Message.QUERY_STRING)) != null) {
            return (String)uri + "?" + query;
        }
        return uri;
    }

    private boolean isBinaryContent(Message message) {
        String contentType = DefaultLogEventMapper.safeGet(message, "Content-Type");
        return contentType != null && this.binaryContentMediaTypes.contains(contentType);
    }

    public boolean isBinaryContent(String contentType) {
        return contentType != null && this.binaryContentMediaTypes.contains(contentType);
    }

    private boolean isMultipartContent(Message message) {
        String contentType = DefaultLogEventMapper.safeGet(message, "Content-Type");
        return contentType != null && contentType.startsWith(MULTIPART_CONTENT_MEDIA_TYPE);
    }

    private boolean isSOAPMessage(Message message) {
        Binding binding = message.getExchange().getBinding();
        return binding != null && "SoapBinding".equals(binding.getClass().getSimpleName());
    }

    private String getMessageId(Message message) {
        AddressingProperties addrProp = ContextUtils.retrieveMAPs(message, false, MessageUtils.isOutbound(message), false);
        return addrProp != null && addrProp.getMessageID() != null ? addrProp.getMessageID().getValue() : UUID.randomUUID().toString();
    }

    private String getOperationName(Message message) {
        String operationName = null;
        BindingOperationInfo boi = message.getExchange().getBindingOperationInfo();
        if (null != boi) {
            operationName = boi.getName().toString();
        }
        return operationName;
    }

    private Message getEffectiveMessage(Message message) {
        boolean isRequestor = MessageUtils.isRequestor(message);
        boolean isOutbound = MessageUtils.isOutbound(message);
        if (isRequestor) {
            return isOutbound ? message : message.getExchange().getOutMessage();
        }
        return isOutbound ? message.getExchange().getInMessage() : message;
    }

    private String getRestOperationName(Message curMessage) {
        Message message = this.getEffectiveMessage(curMessage);
        String httpMethod = DefaultLogEventMapper.safeGet(message, "org.apache.cxf.request.method");
        if (httpMethod == null) {
            return "";
        }
        String path = "";
        String requestUri = DefaultLogEventMapper.safeGet(message, "org.apache.cxf.request.uri");
        if (requestUri != null) {
            String basePath = DefaultLogEventMapper.safeGet(message, Message.BASE_PATH);
            if (basePath == null) {
                path = requestUri;
            } else if (requestUri.startsWith(basePath)) {
                path = requestUri.substring(basePath.length());
            }
            if (path.isEmpty()) {
                path = "/";
            }
        }
        return new StringBuffer().append(httpMethod).append('[').append(path).append(']').toString();
    }

    private static String safeGet(Message message, String key) {
        if (message == null || !message.containsKey(key)) {
            return null;
        }
        Object value = message.get(key);
        return value instanceof String ? value.toString() : null;
    }

    public EventType getEventType(Message message) {
        boolean isOutbound;
        boolean isRequestor = MessageUtils.isRequestor(message);
        boolean isFault = MessageUtils.isFault(message);
        if (!isFault) {
            boolean bl = isFault = !this.isSOAPMessage(message) && this.isRESTFault(message);
        }
        if (isOutbound = MessageUtils.isOutbound(message)) {
            if (isFault) {
                return EventType.FAULT_OUT;
            }
            return isRequestor ? EventType.REQ_OUT : EventType.RESP_OUT;
        }
        if (isFault) {
            return EventType.FAULT_IN;
        }
        return isRequestor ? EventType.RESP_IN : EventType.REQ_IN;
    }

    private boolean isRESTFault(Message message) {
        Object opName = message.getExchange().get("org.apache.cxf.resource.operation.name");
        Integer responseCode = (Integer)message.get(Message.RESPONSE_CODE);
        if (opName == null && responseCode == null) {
            return true;
        }
        return responseCode != null && responseCode >= 400;
    }

    public void setEpInfo(Message message, LogEvent event) {
        EndpointInfo endpoint = this.getEPInfo(message);
        event.setPortName(endpoint.getName());
        event.setPortTypeName(endpoint.getName());
        String opName = this.isSOAPMessage(message) ? this.getOperationName(message) : this.getRestOperationName(message);
        event.setOperationName(opName);
        if (endpoint.getService() != null) {
            this.setServiceInfo(endpoint.getService(), event);
        }
    }

    private void setServiceInfo(ServiceInfo service, LogEvent event) {
        event.setServiceName(service.getName());
        InterfaceInfo iface = service.getInterface();
        event.setPortTypeName(iface.getName());
    }

    private EndpointInfo getEPInfo(Message message) {
        Endpoint ep = message.getExchange().getEndpoint();
        return ep == null ? new EndpointInfo() : ep.getEndpointInfo();
    }

    static {
        HashSet<String> mediaTypes = new HashSet<String>(6);
        mediaTypes.add("application/octet-stream");
        mediaTypes.add("application/pdf");
        mediaTypes.add("image/png");
        mediaTypes.add("image/jpeg");
        mediaTypes.add("image/gif");
        mediaTypes.add("image/bmp");
        DEFAULT_BINARY_CONTENT_MEDIA_TYPES = Collections.unmodifiableSet(mediaTypes);
    }
}

