/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.statistics.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import network.oxalis.ng.persistence.api.JdbcTxManager;
import network.oxalis.ng.statistics.api.RawStatistics;
import network.oxalis.ng.statistics.api.RawStatisticsRepository;
import network.oxalis.ng.statistics.api.StatisticsGranularity;
import network.oxalis.ng.statistics.api.StatisticsTransformer;
import network.oxalis.ng.statistics.util.DataSourceHelper;
import network.oxalis.ng.statistics.util.JdbcHelper;

public abstract class RawStatisticsRepositoryJdbcImpl
implements RawStatisticsRepository {
    public static final String RAW_STATS_TABLE_NAME = "raw_stats";
    protected final JdbcTxManager jdbcTxManager;

    public RawStatisticsRepositoryJdbcImpl(JdbcTxManager jdbcTxManager) {
        this.jdbcTxManager = jdbcTxManager;
    }

    @Override
    public Integer persist(RawStatistics rawStatistics) {
        Connection con = null;
        Integer result = 0;
        try {
            String sqlStatement = this.getPersistSqlQueryText();
            con = this.jdbcTxManager.getConnection();
            PreparedStatement ps = con.prepareStatement(sqlStatement, 1);
            ps.setString(1, rawStatistics.getAccessPointIdentifier().toString());
            ps.setTimestamp(2, new Timestamp(rawStatistics.getDate().getTime()));
            ps.setString(3, rawStatistics.getDirection().toString());
            ps.setString(4, rawStatistics.getSender().getIdentifier());
            ps.setString(5, rawStatistics.getReceiver().getIdentifier());
            ps.setString(6, rawStatistics.getDocumentTypeIdentifier().toString());
            ps.setString(7, rawStatistics.getProcessIdentifier().toString());
            ps.setString(8, rawStatistics.getChannelId() == null ? null : rawStatistics.getChannelId().stringValue());
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            if (rs.next()) {
                result = rs.getInt(1);
                rs.close();
            }
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Unable to execute statement " + e, e);
            }
            catch (Throwable throwable) {
                DataSourceHelper.close(con);
                throw throwable;
            }
        }
        DataSourceHelper.close(con);
        return result;
    }

    @Override
    public void fetchAndTransformRawStatistics(StatisticsTransformer transformer, Date start, Date end, StatisticsGranularity granularity) {
        String sql = this.getRawStatisticsSqlQueryText(granularity);
        start = JdbcHelper.setStartDateIfNull(start);
        end = JdbcHelper.setEndDateIfNull(end);
        Connection con = null;
        try {
            con = this.jdbcTxManager.getConnection();
            PreparedStatement ps = con.prepareStatement(sql);
            ps.setTimestamp(1, new Timestamp(start.getTime()));
            ps.setTimestamp(2, new Timestamp(end.getTime()));
            ps.setTimestamp(3, new Timestamp(start.getTime()));
            ps.setTimestamp(4, new Timestamp(end.getTime()));
            ResultSet rs = ps.executeQuery();
            transformer.startStatistics(start, end);
            while (rs.next()) {
                transformer.startEntry();
                transformer.writeAccessPointIdentifier(rs.getString("ap"));
                transformer.writeDirection(rs.getString("direction"));
                transformer.writePeriod(rs.getString("period"));
                transformer.writeParticipantIdentifier(rs.getString("ppid"));
                transformer.writeDocumentType(rs.getString("doc_type"));
                transformer.writeProfileId(rs.getString("profile"));
                transformer.writeChannel(rs.getString("channel"));
                transformer.writeCount(rs.getInt("count"));
                transformer.endEntry();
            }
            transformer.endStatistics();
        }
        catch (SQLException e) {
            throw new IllegalStateException("SQL error:" + e, e);
        }
        finally {
            DataSourceHelper.close(con);
        }
    }

    abstract String getPersistSqlQueryText();

    abstract String getRawStatisticsSqlQueryText(StatisticsGranularity var1);
}

