/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.mode;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import network.oxalis.commons.certvalidator.api.CrlCache;
import network.oxalis.commons.certvalidator.api.CrlFetcher;
import network.oxalis.commons.certvalidator.util.SimpleCrlCache;
import network.oxalis.ng.api.lang.OxalisLoadingException;
import network.oxalis.ng.commons.guice.OxalisModule;
import network.oxalis.ng.commons.mode.ModeProvider;
import network.oxalis.ng.commons.mode.OxalisCrlFetcher;
import network.oxalis.ng.commons.mode.OxalisOcspFetcher;
import network.oxalis.pkix.ocsp.api.OcspFetcher;
import network.oxalis.vefa.peppol.common.lang.PeppolLoadingException;
import network.oxalis.vefa.peppol.mode.Mode;
import network.oxalis.vefa.peppol.security.api.CertificateValidator;
import org.apache.http.client.config.RequestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModeModule
extends OxalisModule {
    private static final Logger log = LoggerFactory.getLogger(ModeModule.class);

    protected void configure() {
        this.bind(OcspFetcher.class).to(OxalisOcspFetcher.class);
        this.bind(CrlCache.class).toInstance((Object)new SimpleCrlCache());
        this.bind(CrlFetcher.class).to(OxalisCrlFetcher.class);
        this.bind(Mode.class).toProvider(ModeProvider.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    protected CertificateValidator getCertificateValidator(Mode mode) throws PeppolLoadingException {
        return (CertificateValidator)mode.initiate("security.validator.class", CertificateValidator.class);
    }

    @Provides
    @Singleton
    @Named(value="certificate")
    protected RequestConfig getRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
    }

    @Provides
    @Singleton
    @Named(value="truststore-ap")
    protected KeyStore getTruststoreAp(Mode mode) {
        KeyStore keyStore;
        block8: {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(mode.getString("security.truststore.ap"));
            try {
                KeyStore keyStore2 = KeyStore.getInstance("JKS");
                keyStore2.load(inputStream, mode.getString("security.truststore.password").toCharArray());
                keyStore = keyStore2;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new OxalisLoadingException("Unable to load truststore for AP.", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return keyStore;
    }

    @Provides
    @Singleton
    @Named(value="truststore-smp")
    protected KeyStore getTruststoreSmp(Mode mode) {
        KeyStore keyStore;
        block8: {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(mode.getString("security.truststore.smp"));
            try {
                KeyStore keyStore2 = KeyStore.getInstance("JKS");
                keyStore2.load(inputStream, mode.getString("security.truststore.password").toCharArray());
                keyStore = keyStore2;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new OxalisLoadingException("Unable to load truststore for SMP.", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return keyStore;
    }
}

