/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.inbound;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.cert.X509Certificate;
import java.util.Date;
import network.oxalis.ng.as4.inbound.OxalisAS4Version;
import network.oxalis.ng.commons.util.OxalisVersion;
import network.oxalis.vefa.peppol.mode.Mode;

@Singleton
public class AS4StatusServlet
extends HttpServlet {
    private final X509Certificate certificate;
    private final Config config;
    private final Mode mode;

    @Inject
    public AS4StatusServlet(X509Certificate certificate, Config config, Mode mode) {
        this.certificate = certificate;
        this.mode = mode;
        this.config = config;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("text/plain");
        PrintWriter writer = resp.getWriter();
        writer.println("version.oxalis.ng.as4: " + OxalisAS4Version.getVersion());
        writer.println("version.java: " + System.getProperty("java.version"));
        writer.println("mode: " + this.mode.getIdentifier());
        if (this.config.hasPath("lookup.locator.hostname")) {
            writer.print("lookup.locator.hostname: ");
            writer.println(this.config.getString("lookup.locator.hostname"));
        }
        writer.println("certificate.subject: " + this.certificate.getSubjectX500Principal().getName());
        writer.println("certificate.issuer: " + this.certificate.getIssuerX500Principal().getName());
        writer.println("certificate.expired: " + this.certificate.getNotAfter().before(new Date()));
        writer.println("build.id: " + OxalisVersion.getBuildId());
        writer.println("build.tstamp: " + OxalisVersion.getBuildTimeStamp());
    }
}

