/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.outbound.transmission;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.io.IOException;
import java.io.InputStream;
import network.oxalis.ng.api.lang.OxalisContentException;
import network.oxalis.ng.api.lang.OxalisTransmissionException;
import network.oxalis.ng.api.outbound.TransmissionResponse;
import network.oxalis.ng.api.outbound.TransmissionService;
import network.oxalis.ng.api.outbound.Transmitter;
import network.oxalis.ng.api.tag.Tag;
import network.oxalis.ng.commons.tracing.Traceable;
import network.oxalis.ng.outbound.transmission.TransmissionRequestFactory;

@Singleton
class DefaultTransmissionService
extends Traceable
implements TransmissionService {
    private final TransmissionRequestFactory transmissionRequestFactory;
    private final Transmitter transmitter;

    @Inject
    public DefaultTransmissionService(TransmissionRequestFactory transmissionRequestFactory, Transmitter transmitter, Tracer tracer) {
        super(tracer);
        this.transmissionRequestFactory = transmissionRequestFactory;
        this.transmitter = transmitter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransmissionResponse send(InputStream inputStream, Tag tag) throws IOException, OxalisTransmissionException, OxalisContentException {
        Span root = this.tracer.spanBuilder("TransmissionService").startSpan();
        try {
            TransmissionResponse transmissionResponse = this.transmitter.transmit(this.transmissionRequestFactory.newInstance(inputStream, tag));
            return transmissionResponse;
        }
        finally {
            root.end();
        }
    }
}

