/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.spi;

import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;

public class GeneratedClassClassLoader {
    private static final Logger LOG = LogUtils.getL7dLogger(GeneratedClassClassLoader.class);
    protected final Bus bus;

    public GeneratedClassClassLoader(Bus bus) {
        this.bus = bus;
    }

    protected Class<?> findClass(String className, Class<?> callingClass) {
        TypeHelperClassLoader cl = this.getClassLoader();
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return ClassLoaderUtils.loadClass(className, callingClass);
            }
            catch (ClassNotFoundException e) {
                LOG.fine("Failed to load class :" + e.toString());
                return null;
            }
        }
    }

    public TypeHelperClassLoader getClassLoader() {
        TypeHelperClassLoader loader = this.bus.getExtension(TypeHelperClassLoader.class);
        if (loader == null && (loader = this.bus.getExtension(TypeHelperClassLoader.class)) == null) {
            ClassLoader parent = this.bus.getExtension(ClassLoader.class);
            if (parent == null) {
                parent = Thread.currentThread().getContextClassLoader();
            }
            loader = new TypeHelperClassLoader(parent);
            this.bus.setExtension(loader, TypeHelperClassLoader.class);
        }
        return loader;
    }

    public static class TypeHelperClassLoader
    extends ClassLoader {
        private final ConcurrentHashMap<String, Class<?>> defined = new ConcurrentHashMap();

        TypeHelperClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> lookupDefinedClass(String name) {
            return this.defined.get(StringUtils.slashesToPeriod(name));
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.endsWith("package-info")) {
                return this.getParent().loadClass(name);
            }
            return super.findClass(name);
        }

        public Class<?> defineClass(String name, byte[] bytes) {
            String s2;
            Package p;
            Class ret = this.defined.get(StringUtils.slashesToPeriod(name));
            if (ret != null) {
                return ret;
            }
            if (name.endsWith("package-info") && (p = super.getPackage(s2 = name.substring(0, name.length() - 13))) == null) {
                this.definePackage(StringUtils.slashesToPeriod(s2), null, null, null, null, null, null, null);
            }
            ret = this.defined.computeIfAbsent(StringUtils.slashesToPeriod(name), key -> TypeHelperClassLoader.super.defineClass(key, bytes, 0, bytes.length));
            return ret;
        }
    }
}

