/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.persistence.datasource;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.nio.file.Path;
import java.sql.Driver;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.commons.filesystem.ClassLoaderUtils;
import network.oxalis.ng.persistence.util.PersistenceConf;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbcpDataSourceProvider
implements Provider<DataSource> {
    private static final Logger log = LoggerFactory.getLogger(DbcpDataSourceProvider.class);
    private final Settings<PersistenceConf> settings;
    private final Path homeFolder;

    @Inject
    public DbcpDataSourceProvider(Settings<PersistenceConf> settings, @Named(value="home") Path homeFolder) {
        this.settings = settings;
        this.homeFolder = homeFolder;
        log.info("DataSource: {} ", (Object)settings.getString((Object)PersistenceConf.JDBC_CONNECTION_URI));
    }

    public DataSource get() {
        ObjectName dataSourceJmxName;
        log.debug("Configuring DataSource wrapped in a Database Connection Pool, using custom loader");
        Path jdbcDriverClassPath = this.settings.getPath((Object)PersistenceConf.DRIVER_PATH, this.homeFolder);
        log.debug("Loading JDBC Driver with custom class path: " + jdbcDriverClassPath);
        ClassLoader classLoader = ClassLoaderUtils.initiate((Path)jdbcDriverClassPath);
        String className = this.settings.getString((Object)PersistenceConf.DRIVER_CLASS);
        String connectURI = this.settings.getString((Object)PersistenceConf.JDBC_CONNECTION_URI);
        Driver driver = DbcpDataSourceProvider.getJdbcDriver(classLoader, className);
        Properties properties = new Properties();
        properties.put("user", this.settings.getString((Object)PersistenceConf.JDBC_USERNAME));
        properties.put("password", this.settings.getString((Object)PersistenceConf.JDBC_PASSWORD));
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, connectURI, properties);
        try {
            dataSourceJmxName = new ObjectName("network.oxalis", "connectionPool", "OxalisDB");
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)driverConnectionFactory, dataSourceJmxName);
        String validationQuery = this.settings.getString((Object)PersistenceConf.DBCP_VALIDATION_QUERY);
        if (validationQuery != null) {
            poolableConnectionFactory.setValidationQuery(validationQuery);
        }
        GenericObjectPool genericObjectPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
        poolableConnectionFactory.setPool((ObjectPool)genericObjectPool);
        genericObjectPool.setMaxTotal(this.settings.getInt((Object)PersistenceConf.DBCP_MAX_TOTAL));
        genericObjectPool.setMaxIdle(this.settings.getInt((Object)PersistenceConf.DBCP_MAX_IDLE));
        genericObjectPool.setMaxWaitMillis(10000L);
        genericObjectPool.setTestOnBorrow(true);
        genericObjectPool.setTestWhileIdle(true);
        genericObjectPool.setTimeBetweenEvictionRunsMillis(3600000L);
        return new PoolingDataSource((ObjectPool)genericObjectPool);
    }

    private static Driver getJdbcDriver(ClassLoader classLoader, String className) {
        try {
            return (Driver)Class.forName(className, true, classLoader).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to locate class " + className + ".", e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Unable to instantiate driver from class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to access driver class " + className + "; " + e, e);
        }
    }
}

