/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.api.model;

import java.io.Serializable;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import network.oxalis.vefa.peppol.common.model.AbstractSimpleIdentifier;

public class TransmissionIdentifier
extends AbstractSimpleIdentifier
implements Serializable {
    private static final long serialVersionUID = 5280858533226027168L;
    private static final Pattern RFC2822 = Pattern.compile("^<(.+?)>$");

    public static TransmissionIdentifier generateUUID() {
        return TransmissionIdentifier.of(UUID.randomUUID().toString());
    }

    public static TransmissionIdentifier of(String value) {
        return new TransmissionIdentifier(value);
    }

    public static TransmissionIdentifier fromHeader(String value) {
        Matcher matcher = RFC2822.matcher(value);
        if (matcher.matches()) {
            return TransmissionIdentifier.of(matcher.group(1));
        }
        return TransmissionIdentifier.of(value);
    }

    private TransmissionIdentifier(String value) {
        super(value);
    }
}

