/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.statistics.jdbc;

import jakarta.inject.Inject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import network.oxalis.ng.persistence.annotation.Repository;
import network.oxalis.ng.persistence.api.JdbcTxManager;
import network.oxalis.ng.statistics.api.StatisticsGranularity;
import network.oxalis.ng.statistics.api.StatisticsTransformer;
import network.oxalis.ng.statistics.jdbc.RawStatisticsRepositoryJdbcImpl;
import network.oxalis.ng.statistics.util.DataSourceHelper;
import network.oxalis.ng.statistics.util.JdbcHelper;

@Repository
public class RawStatisticsRepositoryHSqlImpl
extends RawStatisticsRepositoryJdbcImpl {
    @Inject
    public RawStatisticsRepositoryHSqlImpl(JdbcTxManager jdbcTxManager) {
        super(jdbcTxManager);
    }

    @Override
    public String getPersistSqlQueryText() {
        return String.format("INSERT INTO %s (ap, tstamp,  direction, sender, receiver, doc_type, profile, channel) values(?,?,?,?,?,?,?,?)", "raw_stats");
    }

    @Override
    public String getRawStatisticsSqlQueryText(StatisticsGranularity granularity) {
        String hSqlDateFormat = RawStatisticsRepositoryHSqlImpl.hSqlDateFormat(granularity);
        return "SELECT\n  ap,\n  'OUT' AS direction,\n  TO_CHAR(tstamp,'" + hSqlDateFormat + "') AS period,\n  sender AS ppid,\n  doc_type,\n  profile,\n  channel,\n  COUNT(id) AS c\nFROM\n  raw_stats\nWHERE\n  direction = 'OUT'\n  and tstamp between ? and ?\nGROUP BY ap,direction,period,ppid,doc_type,profile,channel\nunion\nSELECT\n  ap,\n  'IN' AS direction,\n  TO_CHAR(tstamp,'" + hSqlDateFormat + "') AS period,\n  receiver AS ppid,\n  doc_type,\n  profile,\n  channel,\n  COUNT(id) AS c\nFROM\n  raw_stats\nWHERE\n  direction = 'IN'\n  and tstamp between ? and ?\n\nGROUP BY ap,direction,period,ppid,doc_type,profile,channel\norder by period, ap\n;";
    }

    @Override
    public void fetchAndTransformRawStatistics(StatisticsTransformer transformer, Date start, Date end, StatisticsGranularity granularity) {
        String sql = this.getRawStatisticsSqlQueryText(granularity);
        start = JdbcHelper.setStartDateIfNull(start);
        end = JdbcHelper.setEndDateIfNull(end);
        Connection con = null;
        try {
            con = this.jdbcTxManager.getConnection();
            PreparedStatement ps = con.prepareStatement(sql);
            ps.setTimestamp(1, new Timestamp(start.getTime()));
            ps.setTimestamp(2, new Timestamp(end.getTime()));
            ps.setTimestamp(3, new Timestamp(start.getTime()));
            ps.setTimestamp(4, new Timestamp(end.getTime()));
            ResultSet rs = ps.executeQuery();
            transformer.startStatistics(start, end);
            while (rs.next()) {
                transformer.startEntry();
                transformer.writeAccessPointIdentifier(rs.getString("ap"));
                transformer.writeDirection(rs.getString("direction"));
                transformer.writePeriod(rs.getString("period"));
                transformer.writeParticipantIdentifier(rs.getString("ppid"));
                transformer.writeDocumentType(rs.getString("doc_type"));
                transformer.writeProfileId(rs.getString("profile"));
                transformer.writeChannel(rs.getString("channel"));
                transformer.writeCount(rs.getInt("c"));
                transformer.endEntry();
            }
            transformer.endStatistics();
        }
        catch (SQLException e) {
            throw new IllegalStateException("SQL error:" + e, e);
        }
        finally {
            DataSourceHelper.close(con);
        }
    }

    static String hSqlDateFormat(StatisticsGranularity granularity) {
        switch (granularity) {
            case YEAR: {
                return "YY";
            }
            case MONTH: {
                return "YY-MM";
            }
            case DAY: {
                return "YY-MM-DD";
            }
            case HOUR: {
                return "YY-MM-DD\"T\"HH24";
            }
        }
        throw new IllegalArgumentException("Unable to convert " + granularity + " into a MySQL date_format() string");
    }
}

