/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.persist;

import com.google.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import network.oxalis.ng.api.inbound.InboundMetadata;
import network.oxalis.ng.api.model.TransmissionIdentifier;
import network.oxalis.ng.api.persist.ExceptionPersister;
import network.oxalis.ng.api.persist.PayloadPersister;
import network.oxalis.ng.api.persist.PersisterHandler;
import network.oxalis.ng.api.persist.ReceiptPersister;
import network.oxalis.ng.api.util.Type;
import network.oxalis.vefa.peppol.common.model.Header;

@Singleton
@Type(value={"default"})
public class DefaultPersisterHandler
implements PersisterHandler {
    private PayloadPersister payloadPersister;
    private ReceiptPersister receiptPersister;
    private ExceptionPersister exceptionPersister;

    @Inject
    public DefaultPersisterHandler(PayloadPersister payloadPersister, ReceiptPersister receiptPersister, ExceptionPersister exceptionPersister) {
        this.payloadPersister = payloadPersister;
        this.receiptPersister = receiptPersister;
        this.exceptionPersister = exceptionPersister;
    }

    @Override
    public void persist(InboundMetadata inboundMetadata, Path payloadPath) throws IOException {
        this.receiptPersister.persist(inboundMetadata, payloadPath);
    }

    @Override
    public Path persist(TransmissionIdentifier transmissionIdentifier, Header header, InputStream inputStream) throws IOException {
        return this.payloadPersister.persist(transmissionIdentifier, header, inputStream);
    }

    @Override
    public void persist(TransmissionIdentifier transmissionIdentifier, Header header, Path payloadPath, Exception exception) {
        this.exceptionPersister.persist(transmissionIdentifier, header, payloadPath, exception);
    }
}

