/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.event;

import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ext.logging.event.LogEvent;

public final class LogMessageFormatter {
    private LogMessageFormatter() {
    }

    public static String format(LogEvent event) {
        StringBuilder b = new StringBuilder();
        b.append((Object)event.getType()).append('\n');
        LogMessageFormatter.write(b, "Address", event.getAddress());
        LogMessageFormatter.write(b, "HttpMethod", event.getHttpMethod());
        LogMessageFormatter.write(b, "Content-Type", event.getContentType());
        LogMessageFormatter.write(b, "ResponseCode", event.getResponseCode());
        LogMessageFormatter.write(b, "ExchangeId", event.getExchangeId());
        if (event.getServiceName() != null) {
            LogMessageFormatter.write(b, "ServiceName", LogMessageFormatter.localPart(event.getServiceName()));
            LogMessageFormatter.write(b, "PortName", LogMessageFormatter.localPart(event.getPortName()));
            LogMessageFormatter.write(b, "PortTypeName", LogMessageFormatter.localPart(event.getPortTypeName()));
        }
        if (event.getFullContentFile() != null) {
            LogMessageFormatter.write(b, "FullContentFile", event.getFullContentFile().getAbsolutePath());
        }
        LogMessageFormatter.write(b, "Headers", event.getHeaders().toString());
        if (!StringUtils.isEmpty(event.getPayload())) {
            LogMessageFormatter.write(b, "Payload", event.getPayload());
        }
        return b.toString();
    }

    protected static String localPart(QName name) {
        return name == null ? null : name.getLocalPart();
    }

    protected static void write(StringBuilder b, String key, String value) {
        if (value != null) {
            b.append("    ").append(key).append(": ").append(value).append('\n');
        }
    }
}

