/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.https;

import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.cert.X509Certificate;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.transport.https.AliasedX509ExtendedKeyManager;
import org.apache.cxf.transport.https.AllowAllHostnameVerifier;
import org.apache.cxf.transport.https.SSLContextInitParameters;
import org.apache.cxf.transport.https.httpclient.DefaultHostnameVerifier;
import org.apache.cxf.transport.https.httpclient.PublicSuffixMatcherLoader;

public final class SSLUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(SSLUtils.class);

    private SSLUtils() {
    }

    public static HostnameVerifier getHostnameVerifier(TLSClientParameters tlsClientParameters) {
        HostnameVerifier verifier = tlsClientParameters.getHostnameVerifier() != null ? tlsClientParameters.getHostnameVerifier() : (tlsClientParameters.isUseHttpsURLConnectionDefaultHostnameVerifier() ? HttpsURLConnection.getDefaultHostnameVerifier() : (tlsClientParameters.isDisableCNCheck() ? new AllowAllHostnameVerifier() : new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault())));
        return verifier;
    }

    public static SSLContextInitParameters getSSLContextInitParameters(TLSParameterBase parameters) throws GeneralSecurityException {
        SSLContextInitParameters contextParameters = new SSLContextInitParameters();
        KeyManager[] keyManagers = parameters.getKeyManagers();
        if (keyManagers == null && parameters instanceof TLSClientParameters) {
            keyManagers = org.apache.cxf.configuration.jsse.SSLUtils.getDefaultKeyStoreManagers(LOG);
        }
        KeyManager[] configuredKeyManagers = SSLUtils.configureKeyManagersWithCertAlias(parameters, keyManagers);
        TrustManager[] trustManagers = parameters.getTrustManagers();
        if (trustManagers == null && parameters instanceof TLSClientParameters) {
            trustManagers = org.apache.cxf.configuration.jsse.SSLUtils.getDefaultTrustStoreManagers(LOG);
        }
        contextParameters.setKeyManagers(configuredKeyManagers);
        contextParameters.setTrustManagers(trustManagers);
        return contextParameters;
    }

    public static SSLContext getSSLContext(TLSParameterBase parameters) throws GeneralSecurityException {
        return SSLUtils.getSSLContext(parameters, false);
    }

    public static SSLContext getSSLContext(TLSParameterBase parameters, boolean addHNV) throws GeneralSecurityException {
        String provider = parameters.getJsseProvider();
        String protocol = parameters.getSecureSocketProtocol() != null ? parameters.getSecureSocketProtocol() : "TLS";
        SSLContext ctx = provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, provider);
        SSLContextInitParameters initParams = SSLUtils.getSSLContextInitParameters(parameters);
        TrustManager[] tms = initParams.getTrustManagers();
        if (tms != null && addHNV && parameters instanceof TLSClientParameters) {
            HostnameVerifier hnv = SSLUtils.getHostnameVerifier((TLSClientParameters)parameters);
            for (int i = 0; i < tms.length; ++i) {
                if (!(tms[i] instanceof X509TrustManager)) continue;
                tms[i] = new X509TrustManagerWrapper((X509TrustManager)tms[i], hnv);
            }
        }
        ctx.init(initParams.getKeyManagers(), tms, parameters.getSecureRandom());
        if (parameters instanceof TLSClientParameters && ctx.getClientSessionContext() != null) {
            ctx.getClientSessionContext().setSessionTimeout(((TLSClientParameters)parameters).getSslCacheTimeout());
        }
        return ctx;
    }

    public static KeyManager[] configureKeyManagersWithCertAlias(TLSParameterBase tlsParameters, KeyManager[] keyManagers) throws GeneralSecurityException {
        if (tlsParameters.getCertAlias() == null || keyManagers == null) {
            return keyManagers;
        }
        KeyManager[] copiedKeyManagers = Arrays.copyOf(keyManagers, keyManagers.length);
        for (int idx = 0; idx < copiedKeyManagers.length; ++idx) {
            if (!(copiedKeyManagers[idx] instanceof X509KeyManager) || copiedKeyManagers[idx] instanceof AliasedX509ExtendedKeyManager) continue;
            try {
                copiedKeyManagers[idx] = new AliasedX509ExtendedKeyManager(tlsParameters.getCertAlias(), (X509KeyManager)copiedKeyManagers[idx]);
                continue;
            }
            catch (Exception e) {
                throw new GeneralSecurityException(e);
            }
        }
        return copiedKeyManagers;
    }

    public static SSLEngine createServerSSLEngine(TLSServerParameters parameters) throws Exception {
        SSLContext sslContext = SSLUtils.getSSLContext(parameters);
        SSLEngine serverEngine = sslContext.createSSLEngine();
        serverEngine.setUseClientMode(false);
        serverEngine.setNeedClientAuth(parameters.getClientAuthentication().isRequired());
        return serverEngine;
    }

    public static SSLEngine createClientSSLEngine(TLSClientParameters parameters) throws Exception {
        SSLContext sslContext = SSLUtils.getSSLContext(parameters);
        SSLEngine clientEngine = sslContext.createSSLEngine();
        clientEngine.setUseClientMode(true);
        return clientEngine;
    }

    static class X509TrustManagerWrapper
    extends X509ExtendedTrustManager {
        private final X509TrustManager delegate;
        private final X509ExtendedTrustManager extendedDelegate;
        private final HostnameVerifier verifier;

        X509TrustManagerWrapper(X509TrustManager delegate, HostnameVerifier hnv) {
            this.delegate = delegate;
            this.verifier = hnv;
            this.extendedDelegate = delegate instanceof X509ExtendedTrustManager ? (X509ExtendedTrustManager)delegate : null;
        }

        @Override
        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String s2) throws CertificateException {
            this.delegate.checkClientTrusted(chain, s2);
        }

        @Override
        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String s2, Socket socket) throws CertificateException {
            if (this.extendedDelegate != null) {
                this.extendedDelegate.checkClientTrusted(chain, s2, socket);
            } else {
                this.delegate.checkClientTrusted(chain, s2);
            }
        }

        @Override
        public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String s2, SSLEngine sslEngine) throws CertificateException {
            if (this.extendedDelegate != null) {
                this.extendedDelegate.checkClientTrusted(chain, s2, sslEngine);
            } else {
                this.delegate.checkClientTrusted(chain, s2);
            }
        }

        @Override
        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String s2) throws CertificateException {
            System.out.println("cst1: " + s2);
            this.delegate.checkServerTrusted(chain, s2);
        }

        @Override
        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String s2, Socket socket) throws CertificateException {
            System.out.println("cst2: " + s2);
            if (this.extendedDelegate != null) {
                this.extendedDelegate.checkServerTrusted(chain, s2, socket);
            } else {
                this.delegate.checkServerTrusted(chain, s2);
            }
        }

        private String getHostName(List<SNIServerName> names) {
            if (names == null) {
                return null;
            }
            for (SNIServerName n : names) {
                if (n.getType() != 0 || !(n instanceof SNIHostName)) continue;
                SNIHostName hostname = (SNIHostName)n;
                return hostname.getAsciiName();
            }
            return null;
        }

        @Override
        public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String s2, SSLEngine engine) throws CertificateException {
            if (this.extendedDelegate != null) {
                this.extendedDelegate.checkServerTrusted(chain, s2, new SSLEngineWrapper(engine));
                SSLSession session = engine.getHandshakeSession();
                List<SNIServerName> names = null;
                if (session instanceof ExtendedSSLSession) {
                    ExtendedSSLSession extSession = (ExtendedSSLSession)session;
                    names = extSession.getRequestedServerNames();
                }
                boolean identifiable = false;
                String peerHost = session.getPeerHost();
                String hostname = this.getHostName(names);
                session = new SSLSessionWrapper(session, chain);
                if (hostname != null && this.verifier.verify(hostname, session)) {
                    identifiable = true;
                }
                if (!identifiable && !this.verifier.verify(peerHost, session)) {
                    throw new CertificateException("No name matching " + peerHost + " found");
                }
            } else {
                this.delegate.checkServerTrusted(chain, s2);
            }
        }

        @Override
        public java.security.cert.X509Certificate[] getAcceptedIssuers() {
            return this.delegate.getAcceptedIssuers();
        }
    }

    static class SSLSessionWrapper
    implements SSLSession {
        SSLSession session;
        Certificate[] certificates;

        SSLSessionWrapper(SSLSession s2, Certificate[] certs) {
            this.certificates = certs;
            this.session = s2;
        }

        @Override
        public byte[] getId() {
            return this.session.getId();
        }

        @Override
        public SSLSessionContext getSessionContext() {
            return this.session.getSessionContext();
        }

        @Override
        public long getCreationTime() {
            return this.session.getCreationTime();
        }

        @Override
        public long getLastAccessedTime() {
            return this.session.getLastAccessedTime();
        }

        @Override
        public void invalidate() {
            this.session.invalidate();
        }

        @Override
        public boolean isValid() {
            return this.session.isValid();
        }

        @Override
        public void putValue(String s2, Object o) {
            this.session.putValue(s2, o);
        }

        @Override
        public Object getValue(String s2) {
            return this.session.getValue(s2);
        }

        @Override
        public void removeValue(String s2) {
            this.session.removeValue(s2);
        }

        @Override
        public String[] getValueNames() {
            return this.session.getValueNames();
        }

        @Override
        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            return this.certificates;
        }

        @Override
        public Certificate[] getLocalCertificates() {
            return this.session.getLocalCertificates();
        }

        @Override
        public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
            return this.session.getPeerPrincipal();
        }

        @Override
        public Principal getLocalPrincipal() {
            return this.session.getLocalPrincipal();
        }

        @Override
        public String getCipherSuite() {
            return this.session.getCipherSuite();
        }

        @Override
        public String getProtocol() {
            return this.session.getProtocol();
        }

        @Override
        public String getPeerHost() {
            return this.session.getPeerHost();
        }

        @Override
        public int getPeerPort() {
            return this.session.getPeerPort();
        }

        @Override
        public int getPacketBufferSize() {
            return this.session.getPacketBufferSize();
        }

        @Override
        public int getApplicationBufferSize() {
            return this.session.getApplicationBufferSize();
        }

        @Override
        public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
            return this.session.getPeerCertificateChain();
        }
    }

    static class SSLEngineWrapper
    extends SSLEngine {
        final SSLEngine delegate;

        SSLEngineWrapper(SSLEngine delegate) {
            this.delegate = delegate;
        }

        @Override
        public SSLParameters getSSLParameters() {
            SSLParameters params = this.delegate.getSSLParameters();
            params.setEndpointIdentificationAlgorithm(null);
            return params;
        }

        @Override
        public SSLSession getHandshakeSession() {
            return this.delegate.getHandshakeSession();
        }

        @Override
        public void beginHandshake() throws SSLException {
            this.delegate.beginHandshake();
        }

        @Override
        public void closeInbound() throws SSLException {
            this.delegate.closeInbound();
        }

        @Override
        public void closeOutbound() {
            this.delegate.closeOutbound();
        }

        @Override
        public Runnable getDelegatedTask() {
            return this.delegate.getDelegatedTask();
        }

        @Override
        public boolean getEnableSessionCreation() {
            return this.delegate.getEnableSessionCreation();
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return this.delegate.getEnabledCipherSuites();
        }

        @Override
        public String[] getEnabledProtocols() {
            return this.delegate.getEnabledProtocols();
        }

        @Override
        public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
            return this.delegate.getHandshakeStatus();
        }

        @Override
        public boolean getNeedClientAuth() {
            return this.delegate.getNeedClientAuth();
        }

        @Override
        public SSLSession getSession() {
            return this.delegate.getSession();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public String[] getSupportedProtocols() {
            return this.delegate.getSupportedProtocols();
        }

        @Override
        public boolean getUseClientMode() {
            return this.delegate.getUseClientMode();
        }

        @Override
        public boolean getWantClientAuth() {
            return this.delegate.getWantClientAuth();
        }

        @Override
        public boolean isInboundDone() {
            return this.delegate.isInboundDone();
        }

        @Override
        public boolean isOutboundDone() {
            return this.delegate.isInboundDone();
        }

        @Override
        public void setEnableSessionCreation(boolean arg0) {
            this.delegate.setEnableSessionCreation(arg0);
        }

        @Override
        public void setEnabledCipherSuites(String[] arg0) {
            this.delegate.setEnabledCipherSuites(arg0);
        }

        @Override
        public void setEnabledProtocols(String[] arg0) {
            this.delegate.setEnabledProtocols(arg0);
        }

        @Override
        public void setNeedClientAuth(boolean arg0) {
            this.delegate.setNeedClientAuth(arg0);
        }

        @Override
        public void setUseClientMode(boolean arg0) {
            this.delegate.setUseClientMode(arg0);
        }

        @Override
        public void setWantClientAuth(boolean arg0) {
            this.delegate.setWantClientAuth(arg0);
        }

        @Override
        public SSLEngineResult unwrap(ByteBuffer arg0, ByteBuffer[] arg1, int arg2, int arg3) throws SSLException {
            return null;
        }

        @Override
        public SSLEngineResult wrap(ByteBuffer[] arg0, int arg1, int arg2, ByteBuffer arg3) throws SSLException {
            return null;
        }
    }
}

