/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.GeneralNamesBuilder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.AlgorithmNameFinder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultAlgorithmNameFinder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.cryptacular.CryptoException;
import org.cryptacular.EncodingException;
import org.cryptacular.util.PemUtil;
import org.cryptacular.util.StreamUtil;
import org.cryptacular.x509.dn.NameReader;
import org.cryptacular.x509.dn.RDNSequence;
import org.cryptacular.x509.dn.StandardAttributeType;

public final class CsrUtil {
    private static final AlgorithmNameFinder ALG_NAME_FINDER = new DefaultAlgorithmNameFinder();

    private CsrUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encodeCsr(PKCS10CertificationRequest csr) {
        StringWriter writer = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter(writer);){
            pemWriter.writeObject(csr);
            pemWriter.close();
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new EncodingException("CSR encoding error", e);
        }
    }

    public static CertificationRequest decodeCsr(String csr) {
        byte[] csrBytes = csr.getBytes(StandardCharsets.US_ASCII);
        if (!PemUtil.isPem(csrBytes)) {
            throw new IllegalArgumentException("Input is not PEM-encoded as required");
        }
        csrBytes = PemUtil.decode(csrBytes);
        return CertificationRequest.getInstance(csrBytes);
    }

    public static CertificationRequest decodeCsr(byte[] csr) {
        return CertificationRequest.getInstance(csr);
    }

    public static CertificationRequest readCsr(File file) {
        return CsrUtil.readCsr(StreamUtil.makeStream(file));
    }

    public static CertificationRequest readCsr(InputStream in) {
        byte[] data = StreamUtil.readAll(in);
        if (PemUtil.isPem(data)) {
            return CsrUtil.decodeCsr(PemUtil.decode(data));
        }
        return CsrUtil.decodeCsr(data);
    }

    public static List<String> commonNames(CertificationRequest csr) {
        RDNSequence sequence = NameReader.readX500Name(csr.getCertificationRequestInfo().getSubject());
        return sequence.getValues(StandardAttributeType.CommonName);
    }

    public static List<String> subjectAltNames(CertificationRequest csr) {
        ArrayList<String> names = new ArrayList<String>();
        ASN1Set attributeSet = csr.getCertificationRequestInfo().getAttributes();
        if (attributeSet == null) {
            return names;
        }
        for (ASN1Encodable item : attributeSet) {
            Extensions extensions;
            GeneralNames subjAltNames;
            Attribute attr = Attribute.getInstance(item);
            if (!attr.getAttrType().equals(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest) || (subjAltNames = GeneralNames.fromExtensions(extensions = Extensions.getInstance(attr.getAttributeValues()[0]), Extension.subjectAlternativeName)) == null) continue;
            for (GeneralName gn : subjAltNames.getNames()) {
                names.add(gn.getName().toString().toLowerCase(Locale.ROOT));
            }
        }
        return names;
    }

    public static String sigAlgName(CertificationRequest csr) {
        return ALG_NAME_FINDER.getAlgorithmName(csr.getSignatureAlgorithm()).replace("WITH", "with");
    }

    public static int keyLength(CertificationRequest csr) {
        int length;
        AsymmetricKeyParameter pubKeyParam;
        try {
            pubKeyParam = PublicKeyFactory.createKey(csr.getCertificationRequestInfo().getSubjectPublicKeyInfo());
        }
        catch (IOException e) {
            throw new CryptoException("Error creating public key parameters", e);
        }
        if (pubKeyParam instanceof RSAKeyParameters) {
            length = ((RSAKeyParameters)pubKeyParam).getModulus().bitLength();
        } else if (pubKeyParam instanceof ECKeyParameters) {
            length = ((ECPublicKeyParameters)pubKeyParam).getQ().getXCoord().getFieldSize();
        } else {
            throw new IllegalArgumentException("Unsupported key algorithm");
        }
        return length;
    }

    public static PKCS10CertificationRequest generateCsr(KeyPair keyPair, String subjectDN, String ... subjectAltNames) {
        String sigAlg;
        String keyAlg = keyPair.getPublic().getAlgorithm();
        if ("RSA".equals(keyAlg)) {
            sigAlg = "SHA256withRSA";
        } else if ("EC".equals(keyAlg)) {
            sigAlg = "SHA256withECDSA";
        } else {
            throw new IllegalArgumentException("Unsupported key algorithm");
        }
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(new X500Principal(subjectDN), keyPair.getPublic());
        if (subjectAltNames != null && subjectAltNames.length > 0) {
            GeneralNamesBuilder namesBuilder = new GeneralNamesBuilder();
            for (String subjectAltName : subjectAltNames) {
                namesBuilder.addName(new GeneralName(2, subjectAltName));
            }
            GeneralNames names = namesBuilder.build();
            try {
                Extension sanExtension = Extension.create(Extension.subjectAlternativeName, false, names);
                p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, new Extensions(sanExtension));
            }
            catch (IOException e) {
                throw new CryptoException("Error adding subject alt names to CSR", e);
            }
        }
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(sigAlg);
        try {
            ContentSigner signer = csBuilder.build(keyPair.getPrivate());
            return p10Builder.build(signer);
        }
        catch (OperatorCreationException e) {
            throw new CryptoException("Failed generating CSR", e);
        }
    }
}

