/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.inbound;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.MimeHeader;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.MessageContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import network.oxalis.ng.api.header.HeaderParser;
import network.oxalis.ng.api.inbound.InboundService;
import network.oxalis.ng.api.lang.TimestampException;
import network.oxalis.ng.api.lang.VerifierException;
import network.oxalis.ng.api.model.Direction;
import network.oxalis.ng.api.model.TransmissionIdentifier;
import network.oxalis.ng.api.persist.PersisterHandler;
import network.oxalis.ng.api.timestamp.Timestamp;
import network.oxalis.ng.api.timestamp.TimestampProvider;
import network.oxalis.ng.api.transmission.TransmissionVerifier;
import network.oxalis.ng.as4.common.As4MessageProperties;
import network.oxalis.ng.as4.common.As4MessageProperty;
import network.oxalis.ng.as4.inbound.As4EnvelopeHeader;
import network.oxalis.ng.as4.inbound.As4InboundMetadata;
import network.oxalis.ng.as4.inbound.As4PayloadHeader;
import network.oxalis.ng.as4.inbound.ProsessingContext;
import network.oxalis.ng.as4.lang.OxalisAs4Exception;
import network.oxalis.ng.as4.lang.OxalisAs4TransmissionException;
import network.oxalis.ng.as4.util.AS4ErrorCode;
import network.oxalis.ng.as4.util.As4MessageFactory;
import network.oxalis.ng.as4.util.MessageIdUtil;
import network.oxalis.ng.as4.util.PolicyService;
import network.oxalis.ng.as4.util.SOAPHeaderParser;
import network.oxalis.ng.commons.header.SbdhHeaderParser;
import network.oxalis.ng.commons.io.UnclosableInputStream;
import network.oxalis.ng.commons.mode.OxalisCertificateValidator;
import network.oxalis.vefa.peppol.common.code.DigestMethod;
import network.oxalis.vefa.peppol.common.code.Service;
import network.oxalis.vefa.peppol.common.lang.EndpointNotFoundException;
import network.oxalis.vefa.peppol.common.lang.PeppolLoadingException;
import network.oxalis.vefa.peppol.common.model.Digest;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.InstanceIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.Scheme;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.lookup.LookupClient;
import network.oxalis.vefa.peppol.lookup.LookupClientBuilder;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.mode.Mode;
import network.oxalis.vefa.peppol.sbdh.SbdReader;
import network.oxalis.vefa.peppol.sbdh.lang.SbdhException;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.neethi.Policy;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.CollaborationInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartProperties;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PartyId;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.PayloadInfo;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Property;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.UserMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.xmldsig.ReferenceType;

@Singleton
public class As4InboundHandler {
    private static final Logger log = LoggerFactory.getLogger(As4InboundHandler.class);
    private static final String REQUIRED_PAYLOAD_HREF_PREFIX = "cid:";
    public static final String COMPRESSION_TYPE = "CompressionType";
    private final TransmissionVerifier transmissionVerifier;
    private final PersisterHandler persisterHandler;
    private final TimestampProvider timestampProvider;
    private final HeaderParser headerParser;
    private final As4MessageFactory as4MessageFactory;
    private final PolicyService policyService;
    private final InboundService inboundService;
    private final OxalisCertificateValidator certificateValidator;
    private final Mode mode;
    private final Config config;

    @Inject
    public As4InboundHandler(TransmissionVerifier transmissionVerifier, PersisterHandler persisterHandler, TimestampProvider timestampProvider, HeaderParser headerParser, As4MessageFactory as4MessageFactory, PolicyService policyService, InboundService inboundService, OxalisCertificateValidator certificateValidator, Mode mode, Config config) {
        this.transmissionVerifier = transmissionVerifier;
        this.persisterHandler = persisterHandler;
        this.timestampProvider = timestampProvider;
        this.headerParser = headerParser;
        this.as4MessageFactory = as4MessageFactory;
        this.policyService = policyService;
        this.inboundService = inboundService;
        this.certificateValidator = certificateValidator;
        this.mode = mode;
        this.config = config;
    }

    public SOAPMessage handle(SOAPMessage request, MessageContext messageContext) throws OxalisAs4Exception {
        SOAPHeader soapHeader = this.getSoapHeader(request);
        X509Certificate senderCertificate = this.getSenderCertificate(soapHeader);
        Timestamp timestamp = this.getTimestamp(soapHeader);
        Iterator<AttachmentPart> attachments = CastUtils.cast(request.getAttachments());
        UserMessage userMessage = SOAPHeaderParser.getUserMessage(soapHeader);
        As4EnvelopeHeader envelopeHeader = this.parseAs4EnvelopeHeader(userMessage);
        messageContext.put("network.oxalis.as4.envelope.header", envelopeHeader);
        TransmissionIdentifier messageId = TransmissionIdentifier.of(envelopeHeader.getMessageId());
        this.validateMessageId(messageId.getIdentifier());
        try {
            this.certificateValidator.validate(Service.AP, senderCertificate);
        }
        catch (PeppolSecurityException peppolSecurityException) {
            throw new OxalisAs4Exception("PEPPOL:NOT_SERVICED", AS4ErrorCode.EBMS_0004, AS4ErrorCode.Severity.FAILURE);
        }
        As4InboundHandler.validatePayloads(userMessage.getPayloadInfo());
        List<ReferenceType> referenceList = SOAPHeaderParser.getReferenceListFromSignedInfo(soapHeader);
        ProsessingContext prosessingContext = new ProsessingContext(timestamp, referenceList);
        SOAPMessage response = this.as4MessageFactory.createReceiptMessage(userMessage, prosessingContext);
        if (!this.isPingMessage(userMessage)) {
            byte[] copyOfReceipt = this.copyReceipt(response);
            LinkedHashMap<InputStream, As4PayloadHeader> payloads = this.parseAttachments(attachments, userMessage);
            ArrayList<Path> paths = new ArrayList<Path>();
            for (Map.Entry<InputStream, As4PayloadHeader> payload : payloads.entrySet()) {
                this.validateAttachmentHeader(payload.getValue());
                paths.add(this.persistPayload(payload.getKey(), payload.getValue(), messageId));
            }
            Path firstPayloadPath = (Path)paths.get(0);
            messageContext.put("network.oxalis.as4.first.payload.path", firstPayloadPath);
            messageContext.put("network.oxalis.as4.first.payload.header", payloads.values().iterator().next());
            As4PayloadHeader firstHeader = payloads.entrySet().iterator().next().getValue();
            String firstAttachmentId = envelopeHeader.getPayloadCIDs().get(0);
            Digest firstAttachmentDigest = Digest.of(DigestMethod.SHA256, SOAPHeaderParser.getAttachmentDigest(firstAttachmentId, soapHeader));
            As4InboundMetadata as4InboundMetadata = new As4InboundMetadata(messageId, userMessage.getCollaborationInfo().getConversationId(), firstHeader, timestamp, TransportProfile.AS4, firstAttachmentDigest, senderCertificate, copyOfReceipt, envelopeHeader);
            try {
                if (this.config.hasPath("access.point.isReceiverCheckEnabled")) {
                    this.isThisMessageForUs(this.config, firstHeader, this.mode);
                }
            }
            catch (EndpointNotFoundException | PeppolLoadingException | LookupException | PeppolSecurityException ex) {
                log.warn("Error checking whether this message is for us: " + ex.getMessage());
            }
            catch (OxalisAs4Exception OxalisAs4Exception2) {
                throw new OxalisAs4Exception("PEPPOL:NOT_SERVICED", AS4ErrorCode.EBMS_0004, AS4ErrorCode.Severity.FAILURE);
            }
            try {
                this.persisterHandler.persist(as4InboundMetadata, firstPayloadPath);
            }
            catch (IOException e) {
                throw new OxalisAs4Exception("Error persisting AS4 metadata", e, AS4ErrorCode.EBMS_0202);
            }
            messageContext.put("network.oxalis.as4.persisted", true);
            this.inboundService.complete(as4InboundMetadata);
        }
        Policy policy = null;
        try {
            policy = this.policyService.getPolicy(userMessage.getCollaborationInfo());
        }
        catch (OxalisAs4TransmissionException e) {
            throw new OxalisAs4Exception("Could not get policy", e, AS4ErrorCode.EBMS_0202);
        }
        try {
            response.setProperty(AssertionInfoMap.class.getName(), new AssertionInfoMap(policy));
            response.saveChanges();
        }
        catch (SOAPException e) {
            throw new OxalisAs4Exception("Error persisting AS4 metadata", e, AS4ErrorCode.EBMS_0202);
        }
        return response;
    }

    private X509Certificate getSenderCertificate(SOAPHeader soapHeader) throws OxalisAs4Exception {
        try {
            return SOAPHeaderParser.getSenderCertificate(soapHeader);
        }
        catch (OxalisAs4Exception e) {
            throw new OxalisAs4Exception("PEPPOL:NOT_SERVICED", AS4ErrorCode.EBMS_0004, AS4ErrorCode.Severity.FAILURE);
        }
    }

    private void isThisMessageForUs(Config config, As4PayloadHeader firstHeader, Mode mode) throws PeppolLoadingException, PeppolSecurityException, LookupException, EndpointNotFoundException, OxalisAs4Exception {
        LookupClient lookupClient = LookupClientBuilder.forMode(mode).build();
        if (config.getBoolean("access.point.isReceiverCheckEnabled")) {
            Header header = firstHeader.getHeader();
            Endpoint endpoint = lookupClient.getEndpoint(ParticipantIdentifier.of(header.getReceiver().getIdentifier()), DocumentTypeIdentifier.of(header.getDocumentType().getIdentifier()), ProcessIdentifier.of(header.getProcess().getIdentifier()), TransportProfile.PEPPOL_AS4_2_0);
            String receiverAPEndPointUrlInSMP = endpoint.getAddress().toString();
            if (log.isDebugEnabled()) {
                log.debug("Receiver AP URL retrieved from SMP metadata: " + receiverAPEndPointUrlInSMP);
            }
            String ourOwnAPUrlInOxalisConfig = config.getString("my.access.point.url");
            if (log.isDebugEnabled()) {
                log.debug("Our Receiver AP URL configured in Oxalis Configuration: " + ourOwnAPUrlInOxalisConfig);
            }
            if (ourOwnAPUrlInOxalisConfig == null) {
                log.warn("Oxalis configuration property 'access.point.isReceiverCheckEnabled' is set to true but value is Not provided for configuration property 'my.access.point.url', skipping whether message is for our Access Point. Please ensure that required configuration properties set correctly.");
                return;
            }
            if (receiverAPEndPointUrlInSMP == null || !receiverAPEndPointUrlInSMP.contains(ourOwnAPUrlInOxalisConfig)) {
                throw new OxalisAs4Exception("PEPPOL:NOT_SERVICED", AS4ErrorCode.EBMS_0004, AS4ErrorCode.Severity.FAILURE);
            }
        }
    }

    private boolean isPingMessage(UserMessage userMessage) {
        if (userMessage == null) {
            return false;
        }
        CollaborationInfo collaborationInfo = userMessage.getCollaborationInfo();
        if (collaborationInfo == null) {
            return false;
        }
        return Optional.ofNullable(collaborationInfo.getService()).map(org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.Service::getValue).map(service -> Optional.ofNullable(collaborationInfo.getAction()).map(action -> "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/service".equals(service) && "http://docs.oasis-open.org/ebxml-msg/ebms/v3.0/ns/core/200704/test".equals(action)).orElse(false)).orElse(false);
    }

    public static void validatePayloads(PayloadInfo payloadInfo) throws OxalisAs4Exception {
        List externalPayloads = payloadInfo.getPartInfo().stream().map(PartInfo::getHref).filter(href -> !href.startsWith(REQUIRED_PAYLOAD_HREF_PREFIX)).collect(Collectors.toList());
        if (!externalPayloads.isEmpty()) {
            String errorMessage = "Invalid PayloadInfo. Href(s) detected with \"external\" source: " + externalPayloads;
            log.debug(errorMessage);
            throw new OxalisAs4Exception(errorMessage, AS4ErrorCode.EBMS_0009);
        }
        List payloadsWithInvalidCharset = payloadInfo.getPartInfo().stream().filter(As4InboundHandler::partInfoHasInvalidCharset).map(PartInfo::getHref).collect(Collectors.toList());
        if (!payloadsWithInvalidCharset.isEmpty()) {
            String errorMessage = "Invalid PayloadInfo. Part(s) detected invalid \"CharacterSet\" header: " + payloadsWithInvalidCharset;
            log.debug(errorMessage);
            throw new OxalisAs4Exception(errorMessage, AS4ErrorCode.EBMS_0009);
        }
        List payloadsMissingMimeTypeHeader = payloadInfo.getPartInfo().stream().filter(As4InboundHandler::partInfoMissingMimeTypeHeader).map(PartInfo::getHref).collect(Collectors.toList());
        if (!payloadsMissingMimeTypeHeader.isEmpty()) {
            String errorMessage = "Invalid PayloadInfo. Part(s) detected without \"MimeType\" header: " + payloadsMissingMimeTypeHeader;
            log.debug(errorMessage);
            throw new OxalisAs4Exception(errorMessage, AS4ErrorCode.EBMS_0009);
        }
    }

    private static boolean partInfoHasInvalidCharset(PartInfo partInfo) {
        return Optional.ofNullable(partInfo).map(PartInfo::getPartProperties).map(PartProperties::getProperty).map(Collection::stream).orElse(Stream.empty()).anyMatch(property -> Optional.of(property).map(Property::getName).filter("CharacterSet"::equals).map(fieldName -> Optional.of(property).map(Property::getValue).map(charset -> {
            try {
                return null == Charset.forName(property.getValue());
            }
            catch (Exception e) {
                return true;
            }
        }).orElse(true)).orElse(false));
    }

    public static boolean partInfoMissingMimeTypeHeader(PartInfo partInfo) {
        return Optional.ofNullable(partInfo).map(PartInfo::getPartProperties).map(PartProperties::getProperty).map(Collection::stream).orElse(Stream.empty()).map(Property::getName).noneMatch("MimeType"::equals);
    }

    public byte[] copyReceipt(SOAPMessage response) throws OxalisAs4Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            response.writeTo(bos);
        }
        catch (SOAPException | IOException e) {
            throw new OxalisAs4Exception("Could not write SOAP response", e, AS4ErrorCode.EBMS_0202);
        }
        return bos.toByteArray();
    }

    public void validateMessageId(String messageId) throws OxalisAs4Exception {
        if (!MessageIdUtil.verify(messageId)) {
            throw new OxalisAs4Exception("Invalid Message-ID '" + messageId + "' in inbound message.", AS4ErrorCode.EBMS_0009);
        }
    }

    private LinkedHashMap<InputStream, As4PayloadHeader> parseAttachments(Iterator<AttachmentPart> attachments, UserMessage userMessage) throws OxalisAs4Exception {
        if (!attachments.hasNext()) {
            throw new OxalisAs4Exception("No attachment(s) present");
        }
        Map<String, Map> partInfoHeadersMap = userMessage.getPayloadInfo().getPartInfo().stream().collect(Collectors.toMap(partInfo -> AttachmentUtil.cleanContentId(partInfo.getHref()), partInfo -> partInfo.getPartProperties().getProperty().stream().collect(Collectors.toMap(Property::getName, property -> new MimeHeader(property.getName(), property.getValue())))));
        LinkedHashMap<InputStream, As4PayloadHeader> payloads = new LinkedHashMap<InputStream, As4PayloadHeader>();
        Collection<Attachment> s2 = PhaseInterceptorChain.getCurrentMessage().getAttachments();
        for (Attachment attachment : s2) {
            try {
                Header sbdh;
                InputStream is = attachment.getDataHandler().getInputStream();
                String contentId = AttachmentUtil.cleanContentId(attachment.getId());
                HashMap<String, MimeHeader> mimeHeaders = new HashMap<String, MimeHeader>();
                attachment.getHeaderNames().forEachRemaining(h2 -> mimeHeaders.put((String)h2, new MimeHeader((String)h2, attachment.getHeader((String)h2))));
                Map partInfoHeaders = partInfoHeadersMap.get(contentId);
                if (this.isAttachmentCompressed(partInfoHeaders, mimeHeaders)) {
                    try {
                        is = new GZIPInputStream((InputStream)new BufferedInputStream(is), 8192);
                    }
                    catch (IOException e) {
                        log.info("PartInfo headers: {}", (Object)partInfoHeaders.values().stream().map(p -> p.getName() + "=" + p.getValue()).collect(Collectors.joining(", ", "{", "}")));
                        log.info("MIME headers: {}", (Object)mimeHeaders.values().stream().map(p -> p.getName() + "=" + p.getValue()).collect(Collectors.joining(", ", "{", "}")));
                        throw new OxalisAs4Exception("Unable to initiate decompression of payload with Content-ID: " + contentId, (Throwable)e, AS4ErrorCode.EBMS_0303, AS4ErrorCode.Severity.FAILURE);
                    }
                }
                BufferedInputStream bis = new BufferedInputStream(is, 65536);
                if (this.headerParser instanceof SbdhHeaderParser) {
                    bis.mark(65536);
                    sbdh = this.readHeader(contentId, bis);
                    bis.reset();
                } else {
                    sbdh = new Header().sender(ParticipantIdentifier.of(userMessage.getPartyInfo().getFrom().getPartyId().get(0).getValue())).receiver(ParticipantIdentifier.of(userMessage.getPartyInfo().getTo().getPartyId().get(0).getValue())).documentType(DocumentTypeIdentifier.of(userMessage.getCollaborationInfo().getService().getValue(), Scheme.of(userMessage.getCollaborationInfo().getService().getType()))).identifier(InstanceIdentifier.of(userMessage.getCollaborationInfo().getAction()));
                }
                As4PayloadHeader header = new As4PayloadHeader(sbdh, partInfoHeaders.values(), contentId, userMessage.getMessageInfo().getMessageId());
                payloads.put(bis, header);
            }
            catch (IOException e) {
                throw new OxalisAs4Exception("Could not get attachment input stream", e);
            }
        }
        return payloads;
    }

    private Header readHeader(String contentId, InputStream is) throws OxalisAs4Exception {
        Header header;
        block8: {
            SbdReader sbdReader = SbdReader.newInstance(is);
            try {
                header = sbdReader.getHeader();
                if (sbdReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sbdReader != null) {
                        try {
                            sbdReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SbdhException e) {
                    this.launderZipException(contentId, e);
                    throw new OxalisAs4Exception("Could not extract SBDH from payload");
                }
            }
            sbdReader.close();
        }
        return header;
    }

    private void launderZipException(String contentId, Exception e) throws OxalisAs4Exception {
        Throwable cause = e;
        for (int i = 0; i < 10 && cause != null; ++i) {
            if (cause instanceof ZipException) {
                throw new OxalisAs4Exception("Unable to decompress of payload with Content-ID: " + contentId, cause, AS4ErrorCode.EBMS_0303, AS4ErrorCode.Severity.FAILURE);
            }
            cause = e.getCause();
        }
    }

    private boolean isAttachmentCompressed(Map<String, MimeHeader> partInfoHeaders, Map<String, MimeHeader> mimeHeaders) {
        String value;
        return partInfoHeaders.containsKey(COMPRESSION_TYPE) && "application/gzip".equals(value = partInfoHeaders.get(COMPRESSION_TYPE).getValue());
    }

    private As4EnvelopeHeader parseAs4EnvelopeHeader(UserMessage userMessage) {
        As4EnvelopeHeader as4EnvelopeHeader = new As4EnvelopeHeader();
        as4EnvelopeHeader.setMessageId(userMessage.getMessageInfo().getMessageId());
        as4EnvelopeHeader.setConversationId(userMessage.getCollaborationInfo().getConversationId());
        as4EnvelopeHeader.setFromPartyId(userMessage.getPartyInfo().getFrom().getPartyId().stream().map(PartyId::getValue).collect(Collectors.toList()));
        as4EnvelopeHeader.setFromPartyRole(userMessage.getPartyInfo().getFrom().getRole());
        as4EnvelopeHeader.setToPartyId(userMessage.getPartyInfo().getTo().getPartyId().stream().map(PartyId::getValue).collect(Collectors.toList()));
        as4EnvelopeHeader.setToPartyRole(userMessage.getPartyInfo().getTo().getRole());
        as4EnvelopeHeader.setAction(userMessage.getCollaborationInfo().getAction());
        as4EnvelopeHeader.setService(userMessage.getCollaborationInfo().getService().getValue());
        as4EnvelopeHeader.setMessageProperties(userMessage.getMessageProperties().getProperty().stream().map(p -> new As4MessageProperty(p.getName(), p.getType(), p.getValue())).collect(Collectors.toCollection(As4MessageProperties::new)));
        as4EnvelopeHeader.setPayloadCIDs(userMessage.getPayloadInfo().getPartInfo().stream().map(PartInfo::getHref).collect(Collectors.toList()));
        return as4EnvelopeHeader;
    }

    private Timestamp getTimestamp(SOAPHeader header) throws OxalisAs4Exception {
        byte[] signature = SOAPHeaderParser.getSignature(header);
        try {
            return this.timestampProvider.generate(signature, Direction.IN);
        }
        catch (TimestampException e) {
            throw new OxalisAs4Exception("Error generating timestamp", e);
        }
    }

    private Path persistPayload(InputStream inputStream, As4PayloadHeader as4PayloadHeader, TransmissionIdentifier ti) throws OxalisAs4Exception {
        Path path;
        block8: {
            InputStream is = inputStream;
            try {
                Path payloadPath = this.persisterHandler.persist(ti, as4PayloadHeader, new UnclosableInputStream(is));
                ByteStreams.exhaust(is);
                inputStream.close();
                path = payloadPath;
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.launderZipException(as4PayloadHeader.getCid(), e);
                    throw new OxalisAs4Exception("Error processing payload input stream", e);
                }
            }
            is.close();
        }
        return path;
    }

    private void validateAttachmentHeader(Header attachmentHeader) throws OxalisAs4Exception {
        try {
            this.transmissionVerifier.verify(attachmentHeader, Direction.IN);
        }
        catch (VerifierException e) {
            throw new OxalisAs4Exception("Error verifying SBDH", e);
        }
    }

    private SOAPHeader getSoapHeader(SOAPMessage request) throws OxalisAs4Exception {
        try {
            return request.getSOAPHeader();
        }
        catch (SOAPException e) {
            throw new OxalisAs4Exception("Could not get SOAP header", e);
        }
    }
}

