/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.outbound.transmission;

import com.google.inject.Inject;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import network.oxalis.ng.api.error.ErrorTracker;
import network.oxalis.ng.api.lang.OxalisTransmissionException;
import network.oxalis.ng.api.lookup.LookupService;
import network.oxalis.ng.api.model.Direction;
import network.oxalis.ng.api.outbound.MessageSender;
import network.oxalis.ng.api.outbound.TransmissionMessage;
import network.oxalis.ng.api.outbound.TransmissionRequest;
import network.oxalis.ng.api.outbound.TransmissionResponse;
import network.oxalis.ng.api.outbound.Transmitter;
import network.oxalis.ng.api.statistics.StatisticsService;
import network.oxalis.ng.api.transmission.TransmissionVerifier;
import network.oxalis.ng.commons.mode.OxalisCertificateValidator;
import network.oxalis.ng.commons.tracing.Traceable;
import network.oxalis.ng.outbound.transmission.DefaultTransmissionRequest;
import network.oxalis.ng.outbound.transmission.MessageSenderFactory;
import network.oxalis.vefa.peppol.common.code.Service;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

class DefaultTransmitter
extends Traceable
implements Transmitter {
    private final MessageSenderFactory messageSenderFactory;
    private final StatisticsService statisticsService;
    private final TransmissionVerifier transmissionVerifier;
    private final LookupService lookupService;
    private final OxalisCertificateValidator certificateValidator;
    private final ErrorTracker errorTracker;

    @Inject
    public DefaultTransmitter(MessageSenderFactory messageSenderFactory, StatisticsService statisticsService, TransmissionVerifier transmissionVerifier, LookupService lookupService, Tracer tracer, OxalisCertificateValidator certificateValidator, ErrorTracker errorTracker) {
        super(tracer);
        this.messageSenderFactory = messageSenderFactory;
        this.statisticsService = statisticsService;
        this.transmissionVerifier = transmissionVerifier;
        this.lookupService = lookupService;
        this.certificateValidator = certificateValidator;
        this.errorTracker = errorTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransmissionResponse transmit(TransmissionMessage transmissionMessage) throws OxalisTransmissionException {
        Span span = this.tracer.spanBuilder("transmit").startSpan();
        try {
            TransmissionResponse transmissionResponse = this.perform(transmissionMessage);
            return transmissionResponse;
        }
        finally {
            span.end();
        }
    }

    private TransmissionResponse perform(TransmissionMessage transmissionMessage) throws OxalisTransmissionException {
        try {
            TransmissionRequest transmissionRequest;
            if (transmissionMessage == null) {
                throw new OxalisTransmissionException("No transmission is provided.");
            }
            this.transmissionVerifier.verify(transmissionMessage.getHeader(), Direction.OUT);
            if (transmissionMessage instanceof TransmissionRequest) {
                transmissionRequest = (TransmissionRequest)transmissionMessage;
                if (transmissionRequest.getEndpoint().getCertificate() == null) {
                    throw new OxalisTransmissionException("Certificate of receiving access point is not provided.");
                }
                this.certificateValidator.validate(Service.AP, transmissionRequest.getEndpoint().getCertificate());
            } else {
                transmissionRequest = this.performLookupUserHeaders(transmissionMessage);
            }
            TransmissionResponse transmissionResponse = this.sendMessage(transmissionRequest);
            this.statisticsService.persist(transmissionRequest, transmissionResponse);
            return transmissionResponse;
        }
        catch (PeppolSecurityException e) {
            this.errorTracker.track(Direction.OUT, e, true);
            throw new OxalisTransmissionException("Unable to verify certificate of receiving access point.", (Throwable)e);
        }
        catch (OxalisTransmissionException e) {
            this.errorTracker.track(Direction.OUT, e, true);
            throw e;
        }
        catch (RuntimeException e) {
            this.errorTracker.track(Direction.OUT, e, false);
            throw e;
        }
    }

    private TransmissionRequest performLookupUserHeaders(TransmissionMessage transmissionMessage) throws OxalisTransmissionException {
        DefaultTransmissionRequest transmissionRequest;
        Span span = this.tracer.spanBuilder("Fetch endpoint information").startSpan();
        try {
            Endpoint endpoint = this.lookupService.lookup(transmissionMessage.getHeader());
            span.setAttribute("transport profile", endpoint.getTransportProfile().getIdentifier());
            transmissionRequest = new DefaultTransmissionRequest(transmissionMessage, endpoint);
        }
        catch (OxalisTransmissionException e) {
            span.setAttribute("exception", e.getMessage());
            throw e;
        }
        finally {
            span.end();
        }
        return transmissionRequest;
    }

    private TransmissionResponse sendMessage(TransmissionRequest transmissionRequest) throws OxalisTransmissionException {
        TransmissionResponse transmissionResponse;
        Span span = this.tracer.spanBuilder("send message").startSpan();
        try {
            TransportProfile transportProfile = transmissionRequest.getEndpoint().getTransportProfile();
            MessageSender messageSender = this.messageSenderFactory.getMessageSender(transportProfile);
            transmissionResponse = messageSender.send(transmissionRequest);
        }
        catch (OxalisTransmissionException e) {
            span.setAttribute("exception", e.getMessage());
            throw e;
        }
        finally {
            span.end();
        }
        return transmissionResponse;
    }
}

